/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.module.process;

import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.command.Command;
import org.scijava.command.CommandService;
import org.scijava.log.DefaultLogger;
import org.scijava.log.LogListener;
import org.scijava.log.LogService;
import org.scijava.log.LogSource;
import org.scijava.log.Logger;
import org.scijava.log.TestLogListener;
import org.scijava.plugin.Parameter;

public class LoggerPreprocessorTest {
    @Test
    public void testInjection() throws InterruptedException, ExecutionException {
        Context context = new Context(new Class[]{CommandService.class});
        CommandService commandService = (CommandService)context.service(CommandService.class);
        TestLogListener listener = new TestLogListener();
        ((LogService)context.service(LogService.class)).addLogListener((LogListener)listener);
        commandService.run(CommandWithLogger.class, true, new Object[0]).get();
        Assert.assertTrue((boolean)listener.hasLogged(m -> m.source().path().contains(CommandWithLogger.class.getSimpleName())));
    }

    @Test
    public void testCustomLogger() throws ExecutionException, InterruptedException {
        Context context = new Context(new Class[]{CommandService.class});
        CommandService commandService = (CommandService)context.service(CommandService.class);
        TestLogListener listener = new TestLogListener();
        LogSource source = LogSource.newRoot();
        DefaultLogger customLogger = new DefaultLogger((LogListener)listener, source, 5);
        commandService.run(CommandWithLogger.class, true, new Object[]{"log", customLogger}).get();
        Assert.assertTrue((boolean)listener.hasLogged(m -> m.source().equals(source)));
    }

    @Test
    public void testLoggerNameByAnnotation() throws ExecutionException, InterruptedException {
        Context context = new Context(new Class[]{CommandService.class});
        CommandService commandService = (CommandService)context.service(CommandService.class);
        commandService.run(CommandWithNamedLogger.class, true, new Object[0]).get();
    }

    public static class CommandWithNamedLogger
    implements Command {
        @Parameter(label="MyLoggerName")
        public Logger log;

        public void run() {
            Assert.assertEquals((Object)"MyLoggerName", (Object)this.log.getName());
        }
    }

    public static class CommandWithLogger
    implements Command {
        @Parameter
        public Logger log;

        public void run() {
            this.log.info((Object)"log from the command.");
        }
    }
}

