/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class LastRecentlyUsed<T>
implements Collection<T> {
    private final Object[] entries;
    private final Map<T, Integer> map;
    private final int[] next;
    private final int[] previous;
    private int top;
    private int bottom;

    public LastRecentlyUsed(int size) {
        this.entries = new Object[2 * size];
        this.next = new int[2 * size];
        this.previous = new int[2 * size];
        this.map = new HashMap<T, Integer>();
    }

    public int next(int index) {
        return index < 0 ? this.bottom - 1 : this.next[index] - 1;
    }

    public int previous(int index) {
        return index < 0 ? this.top - 1 : this.previous[index] - 1;
    }

    public T get(int index) {
        return (T)this.entries[index];
    }

    public int lookup(T value) {
        Integer result = this.map.get(value);
        return result == null ? -1 : result;
    }

    @Override
    public boolean add(T value) {
        return this.add(value, false);
    }

    public void addToEnd(T value) {
        this.add(value, true);
    }

    public boolean replace(int index, T newValue) {
        T previousValue = this.get(index);
        if (previousValue == null) {
            throw new IllegalArgumentException("No current entry at position " + index);
        }
        if (newValue.equals(this.previous)) {
            return false;
        }
        this.map.remove(previousValue);
        this.map.put(newValue, index);
        this.entries[index] = newValue;
        return true;
    }

    @Override
    public void clear() {
        this.bottom = 0;
        this.top = 0;
        this.map.clear();
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = null;
            this.previous[i] = 0;
            this.next[i] = 0;
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> values) {
        for (T value : values) {
            this.add(value);
        }
        return true;
    }

    @Override
    public boolean contains(Object value) {
        return this.map.containsKey(value);
    }

    @Override
    public boolean containsAll(Collection<?> values) {
        return this.map.keySet().containsAll(values);
    }

    @Override
    public boolean isEmpty() {
        return this.top == 0;
    }

    @Override
    public boolean remove(Object value) {
        Integer index = this.map.get(value);
        if (index == null) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> values) {
        boolean result = true;
        for (Object value : values) {
            result = this.remove(value) && result;
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> values) {
        int index = this.top - 1;
        while (index >= 0) {
            int prev = this.previous[index] - 1;
            if (!values.contains(this.get(index))) {
                this.remove(index);
            }
            index = prev;
        }
        return this.containsAll(values);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int i = 0;
        int index = this.top - 1;
        while (index >= 0) {
            result[i] = this.get(index);
            ++i;
            index = this.previous[index] - 1;
        }
        return result;
    }

    @Override
    public <S> S[] toArray(S[] array) {
        int size = this.size();
        if (array.length >= size) {
            int i = 0;
            int index = this.top - 1;
            while (index >= 0) {
                array[i] = this.get(index);
                ++i;
                index = this.previous[index] - 1;
            }
            return array;
        }
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        int i = 0;
        int index = this.top - 1;
        while (index >= 0) {
            result[i] = this.get(index);
            ++i;
            index = this.previous[index] - 1;
        }
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int position;
            {
                this.position = LastRecentlyUsed.this.top - 1;
            }

            @Override
            public boolean hasNext() {
                return this.position >= 0;
            }

            @Override
            public T next() {
                Object result = LastRecentlyUsed.this.entries[this.position];
                this.position = LastRecentlyUsed.this.previous[this.position] - 1;
                return result;
            }

            @Override
            public void remove() {
                LastRecentlyUsed.this.remove(this.position == 0 ? LastRecentlyUsed.this.top - 1 : LastRecentlyUsed.this.next[this.position] - 1);
            }
        };
    }

    private void remove(int position) {
        assert (this.entries[position] != null);
        this.map.remove(this.entries[position]);
        this.entries[position] = null;
        if (this.next[position] == 0) {
            this.top = this.previous[position];
        } else {
            this.previous[this.next[position] - 1] = this.previous[position];
        }
        if (this.previous[position] == 0) {
            this.bottom = this.next[position];
        } else {
            this.next[this.previous[position] - 1] = this.next[position];
        }
        this.previous[position] = 0;
        this.next[position] = 0;
    }

    private boolean add(T value, boolean addAtEnd) {
        int insert;
        Integer existing = this.map.get(value);
        if (existing != null) {
            insert = existing;
            this.remove(insert);
        } else if (this.map.size() == this.entries.length / 2) {
            insert = this.bottom - 1;
            this.remove(insert);
        } else {
            insert = value.hashCode() % this.entries.length;
            if (insert < 0) {
                insert += this.entries.length;
            }
            while (insert < this.entries.length && this.entries[insert] != null) {
                ++insert;
            }
        }
        this.add(insert, value, addAtEnd);
        return existing == null;
    }

    private void add(int position, T value, boolean atEnd) {
        assert (this.next[position] == 0);
        assert (this.previous[position] == 0);
        assert (this.entries[position] == null);
        this.map.put(value, position);
        this.entries[position] = value;
        if (atEnd) {
            this.next[position] = this.bottom;
            if (this.bottom > 0) {
                this.previous[this.bottom - 1] = position + 1;
            }
            this.bottom = position + 1;
            if (this.top == 0) {
                this.top = this.bottom;
            }
        } else {
            this.previous[position] = this.top;
            if (this.top > 0) {
                this.next[this.top - 1] = position + 1;
            }
            this.top = position + 1;
            if (this.bottom == 0) {
                this.bottom = this.top;
            }
        }
    }

    protected void assertConsistency() {
        if (this.top == 0) {
            assert (this.bottom == 0);
            assert (this.map.size() == 0);
            for (int i = 0; i < this.entries.length; ++i) {
                assert (this.entries[i] == null);
                assert (this.next[i] == 0);
                assert (this.previous[i] == 0);
            }
            return;
        }
        assert (this.bottom != 0);
        HashSet<Integer> indices = new HashSet<Integer>(this.map.values());
        assert (indices.size() == this.map.size());
        for (int i = 0; i < this.entries.length; ++i) {
            if (indices.contains(i)) {
                assert (this.entries[i] != null);
                assert (this.map.get(this.entries[i]) == i);
                if (i == this.top - 1 || this.top == this.bottom) {
                    assert (this.next[i] == 0);
                } else {
                    assert (this.next[i] > 0);
                    assert (this.previous[this.next[i] - 1] == i + 1);
                }
                if (i == this.bottom - 1 || this.top == this.bottom) {
                    assert (this.previous[i] == 0);
                    continue;
                }
                assert (this.previous[i] > 0);
                assert (this.next[this.previous[i] - 1] == i + 1);
                continue;
            }
            assert (this.entries[i] == null);
            assert (this.next[i] == 0);
            assert (this.previous[i] == 0);
        }
    }
}

