/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import org.junit.Assert;
import org.junit.Test;
import org.scijava.util.ArrayUtils;

public class ArrayUtilsTest {
    @Test
    public void testSafeMultiply32() {
        boolean ok = false;
        try {
            ArrayUtils.safeMultiply32(null);
        }
        catch (NullPointerException e) {
            ok = true;
        }
        if (!ok) {
            Assert.fail((String)"Expected NullPointerException");
        }
        this.assertSafeMultiply32Pass(0, new long[0]);
        this.assertSafeMultiply32Pass(1, 1L);
        this.assertSafeMultiply32Pass(54, 9L, 6L);
        this.assertSafeMultiply32Pass(1037836800, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L);
        this.assertSafeMultiply32Fail("Invalid array size: -1", -1L);
        this.assertSafeMultiply32Fail("Invalid array size: 0", 0L);
        this.assertSafeMultiply32Pass(0x7FFFFFFE, 0x3FFFFFFFL, 2L);
        this.assertSafeMultiply32Fail("Array size too large: 1073741824 x 2", 0x40000000L, 2L);
        this.assertSafeMultiply32Pass(2147441940, 46340L, 46341L);
        this.assertSafeMultiply32Fail("Array size too large: 46341 x 46341", 46341L, 46341L);
        this.assertSafeMultiply32Fail("Array size too large: 46340 x 46342", 46340L, 46342L);
        this.assertSafeMultiply32Pass(0x7FFF0000, 65536L, 32767L);
        this.assertSafeMultiply32Pass(2147450880, 65535L, 32768L);
        this.assertSafeMultiply32Fail("Array size too large: 65536 x 32768", 65536L, 32768L);
    }

    @Test
    public void testSafeMultiply64() {
        boolean ok = false;
        try {
            ArrayUtils.safeMultiply64(null);
        }
        catch (NullPointerException e) {
            ok = true;
        }
        if (!ok) {
            Assert.fail((String)"Expected NullPointerException");
        }
        this.assertSafeMultiply64Pass(0L, new long[0]);
        this.assertSafeMultiply64Pass(1L, 1L);
        this.assertSafeMultiply64Pass(54L, 9L, 6L);
        this.assertSafeMultiply64Pass(3632428800L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L);
        this.assertSafeMultiply64Fail("Invalid array size: -1", -1L);
        this.assertSafeMultiply64Fail("Invalid array size: 0", 0L);
        this.assertSafeMultiply64Pass(0x7FFFFFFFFFFFFFFEL, 0x1555555555555555L, 2L, 3L);
        this.assertSafeMultiply64Fail("Array size too large: 1537228672809129302 x 2 x 3", 0x1555555555555556L, 2L, 3L);
        this.assertSafeMultiply64Pass(9223372033963249500L, 3037000499L, 3037000500L);
        this.assertSafeMultiply64Fail("Array size too large: 3037000500 x 3037000500", 3037000500L, 3037000500L);
        this.assertSafeMultiply64Fail("Array size too large: 3037000499 x 3037000501", 3037000499L, 3037000501L);
    }

    private void assertSafeMultiply32Pass(int expected, long ... sizes) {
        Assert.assertEquals((long)expected, (long)ArrayUtils.safeMultiply32((long[])sizes));
    }

    private void assertSafeMultiply32Fail(String msg, long ... sizes) {
        int actual;
        try {
            actual = ArrayUtils.safeMultiply32((long[])sizes);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)msg);
            return;
        }
        Assert.fail((String)("Safe multiply succeeded with value: " + actual));
    }

    private void assertSafeMultiply64Pass(long expected, long ... sizes) {
        Assert.assertEquals((long)expected, (long)ArrayUtils.safeMultiply64((long[])sizes));
    }

    private void assertSafeMultiply64Fail(String msg, long ... sizes) {
        long actual;
        try {
            actual = ArrayUtils.safeMultiply64((long[])sizes);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)msg);
            return;
        }
        Assert.fail((String)("Safe multiply succeeded with value: " + actual));
    }
}

