/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.object;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.object.NamedObjectIndex;
import org.scijava.object.ObjectService;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.SciJavaPlugin;

public class ObjectServiceTest {
    private Context context;
    private ObjectService objectService;

    @Before
    public void setUp() {
        this.context = new Context(new Class[]{ObjectService.class});
        this.objectService = (ObjectService)this.context.getService(ObjectService.class);
    }

    @After
    public void tearDown() {
        this.context.dispose();
    }

    @Test
    public void testAddRemoveObjects() {
        Object obj1 = new Object();
        String name1 = "Object 1";
        String obj2 = "";
        Double obj3 = new Double(0.3);
        PluginInfo obj4 = PluginInfo.create(TestPlugin.class, SciJavaPlugin.class);
        obj4.setName("TestPlugin name");
        this.objectService.addObject(obj1, name1);
        Assert.assertEquals((String)"Name of object 1", (Object)name1, (Object)this.objectService.getName(obj1));
        this.objectService.addObject((Object)obj2);
        Assert.assertEquals((String)"Name of object 2", (Object)obj2.toString(), (Object)this.objectService.getName((Object)obj2));
        this.objectService.addObject((Object)obj3, null);
        Assert.assertEquals((String)"Name of object 3", (Object)((Object)obj3).toString(), (Object)this.objectService.getName((Object)obj3));
        this.objectService.addObject((Object)obj4);
        Assert.assertNotNull((Object)this.objectService.getName((Object)obj4));
        Assert.assertEquals((String)"Name of object 4", (Object)obj4.getName(), (Object)this.objectService.getName((Object)obj4));
        Assert.assertTrue((String)"Object 1 registered", (boolean)this.objectService.getObjects(Object.class).contains(obj1));
        Assert.assertTrue((String)"Object 2 registered", (boolean)this.objectService.getObjects(Object.class).contains(obj2));
        Assert.assertTrue((String)"Object 3 registered", (boolean)this.objectService.getObjects(Object.class).contains(obj3));
        Assert.assertTrue((String)"Object 4 registered", (boolean)this.objectService.getObjects(Object.class).contains(obj4));
        this.objectService.removeObject(obj1);
        this.objectService.removeObject((Object)obj2);
        this.objectService.removeObject((Object)obj3);
        this.objectService.removeObject((Object)obj4);
        Assert.assertFalse((String)"Object 1 removed", (boolean)this.objectService.getObjects(Object.class).contains(obj1));
        Assert.assertFalse((String)"Object 2 removed", (boolean)this.objectService.getObjects(Object.class).contains(obj2));
        Assert.assertFalse((String)"Object 3 removed", (boolean)this.objectService.getObjects(Object.class).contains(obj3));
        Assert.assertFalse((String)"Object 4 removed", (boolean)this.objectService.getObjects(Object.class).contains(obj4));
    }

    @Test
    public void testNamedObjectIndex() {
        NamedObjectIndex index = this.objectService.getIndex();
        Assert.assertTrue((boolean)(index instanceof NamedObjectIndex));
    }

    private class TestPlugin
    implements SciJavaPlugin {
        private TestPlugin() {
        }
    }
}

