/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.util.ClassUtils;
import org.scijava.util.LongArray;
import org.scijava.util.Types;

public class ConversionUtilsTest {
    @Test
    public void testPrimitiveArray() {
        int i;
        class Struct {
            private int[] intArray;

            Struct() {
            }
        }
        Struct struct = new Struct();
        List<Integer> intVals = Arrays.asList(4, 3, 7);
        this.setFieldValue(struct, "intArray", intVals);
        for (i = 0; i < struct.intArray.length; ++i) {
            Assert.assertEquals((long)intVals.get(i).intValue(), (long)struct.intArray[i]);
        }
        this.setFieldValue(struct, "intArray", new int[]{8, 6, 14});
        for (i = 0; i < struct.intArray.length; ++i) {
            Assert.assertEquals((long)(intVals.get(i) * 2), (long)struct.intArray[i]);
        }
    }

    @Test
    public void testObjectArray() {
        class Struct {
            private Double[] doubleArray;

            Struct() {
            }
        }
        Struct struct = new Struct();
        List<Double> doubleVals = Arrays.asList(1.0, 2.0, 3.0);
        this.setFieldValue(struct, "doubleArray", doubleVals);
        for (int i = 0; i < struct.doubleArray.length; ++i) {
            Assert.assertEquals((Object)doubleVals.get(i), (Object)struct.doubleArray[i]);
        }
    }

    @Test
    public void testCollection() {
        int i;
        class Struct {
            private List<String> stringList;

            Struct() {
            }
        }
        Struct struct = new Struct();
        List<String> stringVals = Arrays.asList("ok", "still ok");
        this.setFieldValue(struct, "stringList", stringVals);
        for (i = 0; i < struct.stringList.size(); ++i) {
            Assert.assertEquals((Object)stringVals.get(i), struct.stringList.get(i));
        }
        this.setFieldValue(struct, "stringList", stringVals.toArray());
        for (i = 0; i < struct.stringList.size(); ++i) {
            Assert.assertEquals((Object)stringVals.get(i), struct.stringList.get(i));
        }
    }

    @Test
    public void testFromCollectionSubclass() {
        class Struct {
            private List<String> stringList;

            Struct() {
            }
        }
        Struct struct = new Struct();
        class RandomSet
        extends HashSet<Random> {
            RandomSet() {
            }
        }
        RandomSet randomSet = new RandomSet();
        randomSet.add(new Random(567L));
        randomSet.add(new Random(321L));
        this.setFieldValue(struct, "stringList", randomSet);
        Assert.assertNotNull((Object)struct.stringList);
        Assert.assertEquals((long)2L, (long)struct.stringList.size());
        for (String s : struct.stringList) {
            Assert.assertTrue((boolean)s.matches("^java.util.Random@[0-9a-f]+$"));
        }
    }

    @Test
    public void testToCollectionSubclass() {
        class Struct {
            private ListExtension<Double> myDoubles;
            private StringListExtension myStrings;

            Struct() {
            }
        }
        Struct struct = new Struct();
        LongArray longArray = new LongArray();
        longArray.add((Object)123456789012L);
        longArray.add((Object)987654321098L);
        this.setFieldValue(struct, "myDoubles", longArray);
        Assert.assertNotNull((Object)struct.myDoubles);
        Assert.assertEquals((long)2L, (long)struct.myDoubles.size());
        Assert.assertEquals((double)1.23456789012E11, (double)((Double)struct.myDoubles.get(0)), (double)0.0);
        Assert.assertEquals((double)9.87654321098E11, (double)((Double)struct.myDoubles.get(1)), (double)0.0);
        this.setFieldValue(struct, "myStrings", longArray);
        Assert.assertNull((Object)struct.myStrings);
    }

    @Test
    public void testNestingMultiElements() {
        class Struct {
            private Set<char[]> nestedArray;

            Struct() {
            }
        }
        Struct struct = new Struct();
        HashSet<char[]> nestedSetValues = new HashSet<char[]>();
        char[] chars = new char[]{'a', 'b', 'c'};
        nestedSetValues.add(chars);
        this.setFieldValue(struct, "nestedArray", nestedSetValues);
        for (char[] charVals : struct.nestedArray) {
            for (int i = 0; i < chars.length; ++i) {
                Assert.assertEquals((long)chars[i], (long)charVals[i]);
            }
        }
    }

    @Test
    public void testSettingSingleElements() {
        class Struct {
            private Double[] doubleArray;
            private List<String> stringList;

            Struct() {
            }
        }
        Struct struct = new Struct();
        double dVal = 6.3;
        this.setFieldValue(struct, "doubleArray", 6.3);
        Assert.assertEquals((Object)new Double(6.3), (Object)struct.doubleArray[0]);
        String sVal = "I am a ghost";
        this.setFieldValue(struct, "stringList", "I am a ghost");
        Assert.assertEquals((Object)"I am a ghost", struct.stringList.get(0));
    }

    public void testBadPrimitiveArray() {
        class Struct {
            private int[] intArray;

            Struct() {
            }
        }
        Struct struct = new Struct();
        this.setFieldValue(struct, "intArray", "not an int array");
        Assert.assertEquals(null, (Object)struct.intArray);
    }

    @Test
    public void testIncompatibleCollections() {
        class Struct {
            private Double[] doubleArray;
            private List<Number> numberList;
            private Set<Integer[]> setOfIntegerArrays;

            Struct() {
            }
        }
        Struct struct = new Struct();
        this.setFieldValue(struct, "doubleArray", "not a double array");
        Assert.assertNotNull((Object)struct.doubleArray);
        Assert.assertEquals((long)1L, (long)struct.doubleArray.length);
        Assert.assertNull((Object)struct.doubleArray[0]);
        this.setFieldValue(struct, "numberList", "not actually a list of numbers");
        List<Number> expectedList = Arrays.asList(new Number[]{null});
        Assert.assertEquals(expectedList, (Object)struct.numberList);
        this.setFieldValue(struct, "setOfIntegerArrays", "definitely not a set of Integer[]");
        Assert.assertNotNull((Object)struct.setOfIntegerArrays);
        Assert.assertEquals((long)1L, (long)struct.setOfIntegerArrays.size());
        Integer[] singleton = (Integer[])struct.setOfIntegerArrays.iterator().next();
        Assert.assertNotNull((Object)singleton);
        Assert.assertEquals((long)1L, (long)singleton.length);
        Assert.assertNull((Object)singleton[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadSingleton() {
        class Struct {
            private int singleValue;

            Struct() {
            }
        }
        Struct struct = new Struct();
        this.setFieldValue(struct, "singleValue", new int[]{4, 8, 2});
    }

    @Test
    public void testLegitimateSingletonArray() {
        class Struct {
            private ArrayWrapper arrayWrapper;

            Struct() {
            }
        }
        Struct struct = new Struct();
        this.setFieldValue(struct, "arrayWrapper", new int[]{4, 8, 2});
        Assert.assertNotNull((Object)struct.arrayWrapper);
    }

    @Test
    public void testLegitimateSingletonCollection() {
        class Struct {
            private ListWrapper listWrapper;

            Struct() {
            }
        }
        Struct struct = new Struct();
        this.setFieldValue(struct, "listWrapper", Arrays.asList(4, 8, 2));
        Assert.assertNotNull((Object)struct.listWrapper);
    }

    private void setFieldValue(Object o, String fieldName, Object value) {
        ClassUtils.setValue((Field)Types.field(o.getClass(), (String)fieldName), (Object)o, (Object)value);
    }

    public static class StringListExtension
    extends ArrayList<String> {
    }

    public static class ListExtension<T>
    extends ArrayList<T> {
    }

    public static class ListWrapper {
        public ListWrapper(List<?> gonnaWrapThisList) {
        }
    }

    public static class ArrayWrapper {
        public ArrayWrapper(int[] gonnaWrapThisArray) {
        }
    }

    private static interface INumberList
    extends List<Number> {
    }

    public static class NumberList
    extends ArrayList<Number>
    implements INumberList {
        public NumberList() {
        }

        public NumberList(Collection<? extends Number> c) {
            super(c);
        }
    }

    public static class ObjectList
    extends ArrayList<Object> {
        public ObjectList(Collection<? extends Object> c) {
            super(c);
        }
    }

    public static class HerList
    extends ArrayList<String> {
        public HerList(Collection<? extends String> c) {
            super(c);
        }
    }

    public static class HisList
    extends ArrayList<String> {
        public HisList() {
        }

        public HisList(Collection<? extends String> c) {
            super(c);
        }
    }
}

