/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.IOException;
import org.scijava.io.handle.AbstractStreamHandle;
import org.scijava.io.handle.SeekableStreamHandle;
import org.scijava.io.location.Location;

public abstract class AbstractSeekableStreamHandle<L extends Location>
extends AbstractStreamHandle<L>
implements SeekableStreamHandle<L> {
    private long jumpCutoff = 10000L;

    @Override
    public void seek(long pos) throws IOException {
        long delta = pos - this.offset();
        if (delta == 0L) {
            return;
        }
        if (delta > 0L) {
            if (this.recreatePossible() && delta > this.jumpCutoff) {
                this.recreateStreamFromPos(pos);
            } else {
                this.jump(delta);
            }
        } else if (this.recreatePossible()) {
            this.recreateStreamFromPos(pos);
        } else {
            this.resetStream();
            this.jump(pos);
        }
        this.setOffset(pos);
    }

    protected abstract void recreateStreamFromPos(long var1) throws IOException;

    protected abstract boolean recreatePossible() throws IOException;

    protected void setJumpCutoff(long jumpCutoff) {
        this.jumpCutoff = jumpCutoff;
    }
}

