/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.main;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.console.ConsoleService;
import org.scijava.main.MainService;

public class MainServiceTest {
    private MainService mainService;

    @Before
    public void setUp() {
        MathMain.resultCount = 0;
        Context context = new Context();
        this.mainService = (MainService)context.service(MainService.class);
    }

    @After
    public void tearDown() {
        this.mainService.context().dispose();
    }

    @Test
    public void testMainService() {
        int mainCount0 = this.mainService.execMains();
        Assert.assertEquals((long)0L, (long)mainCount0);
        this.mainService.addMain(MathMain.class.getName(), new String[]{"12.3", "/", "4.56"});
        int mainCount1 = this.mainService.execMains();
        Assert.assertEquals((long)1L, (long)mainCount1);
        Assert.assertEquals((Object)System.getProperty(MainServiceTest.key(0)), (Object)"2.697368421052632");
    }

    @Test
    public void testConsoleArgs() {
        Assert.assertEquals((long)0L, (long)this.mainService.getMains().length);
        ConsoleService consoleService = (ConsoleService)this.mainService.context().service(ConsoleService.class);
        consoleService.processArgs(new String[]{"-Dmain.test.foo=bar", "--main", "org.scijava.main.MainServiceTest$MathMain", "5", "+", "6", "--", "-Dmain.test.whiz=bang", "--main", "org.scijava.main.MainServiceTest$MathMain", "7", "-", "4"});
        MainService.Main[] m = this.mainService.getMains();
        Assert.assertEquals((long)2L, (long)m.length);
        Assert.assertEquals((Object)"org.scijava.main.MainServiceTest$MathMain", (Object)m[0].className());
        Assert.assertArrayEquals((Object[])new String[]{"5", "+", "6"}, (Object[])m[0].args());
        Assert.assertEquals((Object)"org.scijava.main.MainServiceTest$MathMain", (Object)m[1].className());
        Assert.assertArrayEquals((Object[])new String[]{"7", "-", "4"}, (Object[])m[1].args());
        int mainCount = this.mainService.execMains();
        Assert.assertEquals((long)2L, (long)mainCount);
        Assert.assertEquals((Object)System.getProperty(MainServiceTest.key(0)), (Object)"11.0");
        Assert.assertEquals((Object)System.getProperty(MainServiceTest.key(1)), (Object)"3.0");
        Assert.assertEquals((Object)System.getProperty("main.test.foo"), (Object)"bar");
        Assert.assertEquals((Object)System.getProperty("main.test.whiz"), (Object)"bang");
    }

    private static String key(int index) {
        return MathMain.class.getName() + ":" + index;
    }

    private static class MathMain {
        private static int resultCount = 0;

        private MathMain() {
        }

        public static void main(String[] args) {
            double result;
            if (args.length != 3) {
                throw new IllegalArgumentException("Invalid args: " + args);
            }
            double operand1 = Double.parseDouble(args[0]);
            String operator = args[1];
            double operand2 = Double.parseDouble(args[2]);
            if (operator.equals("+")) {
                result = operand1 + operand2;
            } else if (operator.equals("-")) {
                result = operand1 - operand2;
            } else if (operator.equals("*")) {
                result = operand1 * operand2;
            } else if (operator.equals("/")) {
                result = operand1 / operand2;
            } else {
                throw new IllegalArgumentException("Unknown operator: " + operator);
            }
            String key = MathMain.class.getName() + ":" + resultCount++;
            String value = "" + result;
            System.setProperty(key, value);
        }
    }
}

