/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.io.IOService;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.Location;
import org.scijava.plugin.PluginInfo;
import org.scijava.text.AbstractTextFormat;
import org.scijava.text.TextFormat;

public class IOServiceTest {
    @Test
    public void testTextFile() throws IOException {
        Context ctx = new Context();
        ctx.getPluginIndex().add((Object)new PluginInfo(DummyTextFormat.class, TextFormat.class));
        IOService io = (IOService)ctx.getService(IOService.class);
        String localFile = this.getClass().getResource("test.txt").getPath();
        Object obj = io.open(localFile);
        Assert.assertNotNull((Object)obj);
        String content = obj.toString();
        Assert.assertTrue((boolean)content.contains("content"));
        obj = io.open((Location)new FileLocation(localFile));
        Assert.assertNotNull((Object)obj);
        Assert.assertEquals((Object)content, (Object)obj.toString());
    }

    public static class DummyTextFormat
    extends AbstractTextFormat {
        public List<String> getExtensions() {
            return Collections.singletonList("txt");
        }

        public String asHTML(String text) {
            return text;
        }
    }
}

