/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.object;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.object.ObjectIndex;

public class ObjectIndexTest {
    @Test
    public void testGetAll() {
        ObjectIndex objectIndex = new ObjectIndex(Object.class);
        Integer o1 = new Integer(5);
        Float o2 = new Float(2.5f);
        Integer o3 = new Integer(3);
        objectIndex.add((Object)o1);
        objectIndex.add((Object)o2);
        objectIndex.add((Object)o3);
        List all = objectIndex.getAll();
        Assert.assertEquals((long)3L, (long)all.size());
        Assert.assertSame((Object)o1, all.get(0));
        Assert.assertSame((Object)o2, all.get(1));
        Assert.assertSame((Object)o3, all.get(2));
    }

    @Test
    public void testGet() {
        ObjectIndex objectIndex = new ObjectIndex(Object.class);
        Integer o1 = new Integer(5);
        Float o2 = new Float(2.5f);
        Integer o3 = new Integer(3);
        objectIndex.add((Object)o1);
        objectIndex.add((Object)o2);
        objectIndex.add((Object)o3);
        List integers = objectIndex.get(Integer.class);
        Assert.assertEquals((long)2L, (long)integers.size());
        Assert.assertSame((Object)o1, integers.get(0));
        Assert.assertSame((Object)o3, integers.get(1));
        List numbers = objectIndex.get(Number.class);
        Assert.assertEquals((long)numbers.size(), (long)3L);
        Assert.assertSame((Object)o1, numbers.get(0));
        Assert.assertSame((Object)o2, numbers.get(1));
        Assert.assertSame((Object)o3, numbers.get(2));
    }

    @Test
    public void testIsEmpty() {
        ObjectIndex objectIndex = new ObjectIndex(Object.class);
        Assert.assertTrue((boolean)objectIndex.isEmpty());
        Integer o1 = new Integer(5);
        objectIndex.add((Object)o1);
        Assert.assertFalse((boolean)objectIndex.isEmpty());
        objectIndex.remove((Object)o1);
        Assert.assertTrue((boolean)objectIndex.isEmpty());
    }

    @Test
    public void testContains() {
        ObjectIndex objectIndex = new ObjectIndex(Object.class);
        Integer o1 = new Integer(5);
        Assert.assertFalse((boolean)objectIndex.contains((Object)o1));
        objectIndex.add((Object)o1);
        Assert.assertTrue((boolean)objectIndex.contains((Object)o1));
        objectIndex.remove((Object)o1);
        Assert.assertFalse((boolean)objectIndex.contains((Object)o1));
    }

    @Test
    public void testIterator() {
        Object[] objects;
        ObjectIndex objectIndex = new ObjectIndex(Object.class);
        for (Object o : objects = new Object[]{new Integer(5), new Float(2.5f), new Integer(3)}) {
            objectIndex.add(o);
        }
        Iterator iter = objectIndex.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Object o = iter.next();
            Assert.assertSame((Object)objects[i], o);
            ++i;
        }
    }

    @Test
    public void testToArray() {
        Object[] objects;
        ObjectIndex objectIndex = new ObjectIndex(Object.class);
        for (Object o : objects = new Object[]{new Integer(5), new Float(2.5f), new Integer(3)}) {
            objectIndex.add(o);
        }
        Object[] result = objectIndex.toArray();
        Assert.assertArrayEquals((Object[])objects, (Object[])result);
    }

    @Test
    public void testContainsAll() {
        ObjectIndex objectIndex = new ObjectIndex(Object.class);
        Assert.assertTrue((boolean)objectIndex.containsAll(new ArrayList()));
        Integer o1 = new Integer(5);
        Float o2 = new Float(2.5f);
        Integer o3 = new Integer(3);
        ArrayList<Number> objects = new ArrayList<Number>();
        objects.add(o1);
        objects.add(o2);
        objects.add(o3);
        objectIndex.addAll(objects);
        objects.remove(o3);
        Assert.assertTrue((boolean)objectIndex.containsAll(objects));
        objectIndex.remove((Object)o1);
        Assert.assertFalse((boolean)objectIndex.containsAll(objects));
    }

    @Test
    public void testAddAll() {
        ObjectIndex objectIndex = new ObjectIndex(Object.class);
        ArrayList<Number> objects = new ArrayList<Number>();
        objects.add(new Integer(5));
        objects.add(new Float(2.5f));
        objects.add(new Integer(3));
        objectIndex.addAll(objects);
        List result = objectIndex.getAll();
        Assert.assertEquals(objects, (Object)result);
    }

    @Test
    public void testRemoveAll() {
        ObjectIndex objectIndex = new ObjectIndex(Object.class);
        Integer o1 = new Integer(5);
        Float o2 = new Float(2.5f);
        Integer o3 = new Integer(3);
        ArrayList<Number> objects = new ArrayList<Number>();
        objects.add(o1);
        objects.add(o2);
        objects.add(o3);
        objectIndex.addAll(objects);
        Assert.assertEquals((long)3L, (long)objectIndex.size());
        objects.remove(o2);
        objectIndex.removeAll(objects);
        Assert.assertEquals((long)1L, (long)objectIndex.size());
        Assert.assertSame((Object)o2, objectIndex.getAll().get(0));
    }

    @Test
    public void testClear() {
        ObjectIndex objectIndex = new ObjectIndex(Object.class);
        objectIndex.clear();
        Assert.assertTrue((boolean)objectIndex.isEmpty());
        objectIndex.add((Object)new Integer(5));
        Assert.assertFalse((boolean)objectIndex.isEmpty());
        objectIndex.clear();
        Assert.assertTrue((boolean)objectIndex.isEmpty());
    }

    @Test
    public void testToString() {
        ObjectIndex objectIndex = new ObjectIndex(Object.class);
        objectIndex.add((Object)new Integer(5));
        objectIndex.add((Object)new Float(2.5f));
        objectIndex.add((Object)new Integer(3));
        ArrayList<String> expected = new ArrayList<String>();
        expected.addAll(Arrays.asList("java.io.Serializable: {5, 2.5, 3}", "java.lang.Comparable: {5, 2.5, 3}", "java.lang.Float: {2.5}", "java.lang.Integer: {5, 3}", "java.lang.Number: {5, 2.5, 3}", "java.lang.Object: {5, 2.5, 3}"));
        String[] javaVersion = System.getProperty("java.version").split("\\.");
        int majorVersion = Integer.parseInt(javaVersion[0]);
        if (majorVersion >= 12) {
            expected.add("java.lang.constant.Constable: {5, 2.5, 3}");
            expected.add("java.lang.constant.ConstantDesc: {5, 2.5, 3}");
        }
        expected.add("org.scijava.object.ObjectIndex$All: {5, 2.5, 3}");
        Object[] actual = objectIndex.toString().split(System.getProperty("line.separator"));
        Assert.assertArrayEquals((Object[])expected.toArray(), (Object[])actual);
    }
}

