/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.location;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.FileLocationResolver;
import org.scijava.io.location.Location;
import org.scijava.io.location.LocationResolver;
import org.scijava.io.location.LocationService;

public class LocationServiceTest {
    @Test
    public void testResolve() throws URISyntaxException {
        Context ctx = new Context(new Class[]{LocationService.class});
        LocationService loc = (LocationService)ctx.getService(LocationService.class);
        URI uri = new File(new File(".").getAbsolutePath()).toURI();
        LocationResolver res = (LocationResolver)loc.getHandler((Object)uri);
        Assert.assertTrue((boolean)(res instanceof FileLocationResolver));
        Assert.assertEquals((Object)uri, (Object)res.resolve(uri).getURI());
        Assert.assertEquals((Object)uri, (Object)loc.resolve(uri).getURI());
        Assert.assertEquals((Object)uri, (Object)loc.resolve(uri.toString()).getURI());
    }

    @Test
    public void testResolveWindowsPath() throws URISyntaxException {
        Context ctx = new Context(new Class[]{LocationService.class});
        LocationService loc = (LocationService)ctx.getService(LocationService.class);
        String pSlash = "C:/Windows/FilePath/image.tif";
        Location locSlash = loc.resolve(pSlash);
        Assert.assertTrue((boolean)(locSlash instanceof FileLocation));
        String pBackslash = pSlash.replace('/', '\\');
        Location locBackslash = loc.resolve(pBackslash);
        Assert.assertTrue((boolean)(locBackslash instanceof FileLocation));
        Location locSlashURI = loc.resolve(new URI(pSlash));
        Assert.assertNull((Object)locSlashURI);
    }

    @Test
    public void testFallBack() throws URISyntaxException {
        Context ctx = new Context(new Class[]{LocationService.class});
        LocationService loc = (LocationService)ctx.getService(LocationService.class);
        String uri = new File(".").getAbsolutePath();
        Location res = loc.resolve(uri);
        Assert.assertTrue((boolean)(res instanceof FileLocation));
        FileLocation resFile = (FileLocation)res;
        Assert.assertEquals((Object)uri, (Object)resFile.getFile().getAbsolutePath());
    }
}

