/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.sjep;

import java.util.Arrays;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.sjep.AbstractTest;
import org.scijava.sjep.Function;
import org.scijava.sjep.Group;
import org.scijava.sjep.Operators;
import org.scijava.sjep.SyntaxTree;
import org.scijava.sjep.Variable;

public class SyntaxTreeTest
extends AbstractTest {
    @Test
    public void testSimple() {
        LinkedList<Object> queue = this.queue(this.var("a"), this.var("b"), this.var("c"), Operators.MUL, Operators.ADD);
        LinkedList<Object> expected = new LinkedList<Object>(queue);
        SyntaxTree tree = new SyntaxTree(queue);
        Assert.assertNotNull((Object)tree);
        Assert.assertSame((Object)Operators.ADD, (Object)tree.token());
        this.assertCount(2, tree);
        this.assertVariable("a", tree.child(0).token());
        Assert.assertSame((Object)Operators.MUL, (Object)tree.child(1).token());
        this.assertCount(2, tree.child(1));
        this.assertVariable("b", tree.child(1).child(0).token());
        this.assertVariable("c", tree.child(1).child(1).token());
        this.assertSameLists(expected, tree.postfix());
    }

    @Test
    public void testComplicated() {
        LinkedList<Object> queue = this.queue(this.var("a"), this.var("b"), Operators.DIV, this.var("c"), Operators.MUL, this.var("a"), this.var("b"), this.var("c"), Operators.POW, Operators.POW, Operators.ADD, this.var("f"), this.var("d"), this.var("c"), this.var("b"), this.var("a"), this.group(Operators.PARENS, 4), this.func(), Operators.SUB);
        LinkedList<Object> expected = new LinkedList<Object>(queue);
        SyntaxTree tree = new SyntaxTree(queue);
        Assert.assertNotNull((Object)tree);
        Assert.assertSame((Object)Operators.SUB, (Object)this.token(tree, new int[0]));
        Assert.assertSame((Object)Operators.ADD, (Object)this.token(tree, 0));
        Assert.assertSame((Object)Operators.MUL, (Object)this.token(tree, 0, 0));
        Assert.assertSame((Object)Operators.DIV, (Object)this.token(tree, 0, 0, 0));
        this.assertVariable("a", this.token(tree, 0, 0, 0, 0));
        this.assertVariable("b", this.token(tree, 0, 0, 0, 1));
        this.assertVariable("c", this.token(tree, 0, 0, 1));
        Assert.assertSame((Object)Operators.POW, (Object)this.token(tree, 0, 1));
        this.assertVariable("a", this.token(tree, 0, 1, 0));
        Assert.assertSame((Object)Operators.POW, (Object)this.token(tree, 0, 1, 1));
        this.assertVariable("b", this.token(tree, 0, 1, 1, 0));
        this.assertVariable("c", this.token(tree, 0, 1, 1, 1));
        this.assertFunction(this.token(tree, 1));
        this.assertVariable("f", this.token(tree, 1, 0));
        this.assertGroup(Operators.PARENS, 4, this.token(tree, 1, 1));
        this.assertVariable("d", this.token(tree, 1, 1, 0));
        this.assertVariable("c", this.token(tree, 1, 1, 1));
        this.assertVariable("b", this.token(tree, 1, 1, 2));
        this.assertVariable("a", this.token(tree, 1, 1, 3));
        this.assertSameLists(expected, tree.postfix());
    }

    private LinkedList<Object> queue(Object ... args) {
        return new LinkedList<Object>(Arrays.asList(args));
    }

    private Variable var(String token) {
        return new Variable(token);
    }

    private Group group(Group g, int arity) {
        Group group = g.instance();
        for (int a = 0; a < arity; ++a) {
            group.incArity();
        }
        return group;
    }

    private Function func() {
        return new Function(0.0);
    }

    private Object token(SyntaxTree tree, int ... indices) {
        if (indices.length == 0) {
            return tree.token();
        }
        int[] subIndices = new int[indices.length - 1];
        System.arraycopy(indices, 1, subIndices, 0, subIndices.length);
        return this.token(tree.child(indices[0]), subIndices);
    }
}

