/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.sjep;

import org.scijava.sjep.Operator;

public class Group
extends Operator {
    private final String terminator;
    private int arity;

    public Group(String initiator, String terminator, double precedence) {
        super(initiator, 0, Operator.Associativity.NONE, precedence);
        this.terminator = terminator;
    }

    public String getTerminator() {
        return this.terminator;
    }

    public void incArity() {
        ++this.arity;
    }

    public boolean matches(Group g) {
        return this.getToken().equals(g.getToken()) && this.getTerminator().equals(g.getTerminator()) && this.getPrecedence() == g.getPrecedence();
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    @Override
    public boolean isInfix() {
        return true;
    }

    @Override
    public boolean isPrefix() {
        return true;
    }

    @Override
    public Group instance() {
        return new Group(this.getToken(), this.getTerminator(), this.getPrecedence());
    }

    @Override
    public String toString() {
        return this.getToken() + this.getArity() + this.getTerminator();
    }
}

