/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;

public class VerifyNoSnapshotsMojo
extends AbstractMojo {
    private Set<String> processedGavs = new HashSet<String>();
    private boolean foundSnapshot = false;
    private List remoteRepositories;
    private MavenProject mavenProject;
    private MavenProjectBuilder m_projectBuilder;
    private ArtifactRepository m_localRepository;
    private Boolean failEarly;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.remoteRepositories = this.mavenProject.getRemoteArtifactRepositories();
        this.checkProject(this.mavenProject);
        if (this.foundSnapshot) {
            throw new MojoFailureException("Found one or more SNAPSHOT couplings. See error log for more information.");
        }
    }

    private void checkProject(MavenProject project) throws MojoFailureException {
        this.checkProjectHelper(project, "\t" + this.gav(project));
    }

    private void checkProjectHelper(MavenProject project, String path) throws MojoFailureException {
        this.checkParent(project, path);
        List dependencies = project.getDependencies();
        for (Dependency d : dependencies) {
            try {
                DefaultArtifact a = new DefaultArtifact(d.getGroupId(), d.getArtifactId(), VersionRange.createFromVersion((String)d.getVersion()), d.getScope(), d.getType(), d.getClassifier(), project.getArtifact().getArtifactHandler());
                MavenProject dep = this.m_projectBuilder.buildFromRepository((Artifact)a, this.remoteRepositories, this.m_localRepository);
                String gav = this.gav(dep);
                if (this.processedGavs.contains(gav)) continue;
                this.processedGavs.add(gav);
                String depPath = this.makePath(path, dep);
                this.getLog().debug((CharSequence)("checking pom:\n" + depPath));
                if (dep.getVersion().contains("SNAPSHOT")) {
                    this.setFailure("Found SNAPSHOT version:\n" + depPath);
                }
                this.checkProjectHelper(dep, depPath);
            }
            catch (ProjectBuildingException e) {
                this.getLog().error((CharSequence)("Could not resolve dependency: " + d + " of path:\n" + path));
            }
        }
    }

    private void checkParent(MavenProject pom, String path) throws MojoFailureException {
        MavenProject parent;
        if (pom.hasParent() && !this.processedGavs.contains(this.gav(parent = pom.getParent()))) {
            this.processedGavs.add(this.gav(parent));
            String parentPath = this.makePath(path, parent);
            this.getLog().debug((CharSequence)("checking parent:\n" + parentPath));
            if (parent.getVersion().contains("SNAPSHOT")) {
                this.setFailure("Found SNAPSHOT parent:\n" + parentPath);
            }
            this.checkParent(parent, parentPath);
        }
    }

    private String makePath(String path, MavenProject project) {
        String newPath = "\t" + this.gav(project) + "\n" + path;
        return newPath;
    }

    private String gav(MavenProject project) {
        return project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion();
    }

    private void setFailure(String message) throws MojoFailureException {
        if (this.failEarly.booleanValue()) {
            throw new MojoFailureException(message);
        }
        this.getLog().error((CharSequence)message);
        this.foundSnapshot = true;
    }
}

