/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Counts;
import fit.FitProtocol;
import fit.FitServer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.FileUtil;
import util.RegexTestCase;
import util.StreamReader;

public class FitServerTest {
    private static final int PORT_NUMBER = 1634;
    private Process process;
    private Socket socket;
    private ServerSocket serverSocket;
    private InputStream socketInput;
    private OutputStream socketOutput;
    private byte[] httpRequest;
    private ByteArrayOutputStream stdoutBytes;
    private String connectionStatusSize = "0000000000";

    @Before
    public void setup() {
        String sentinelName = FitServer.sentinelName((int)1634);
        FileUtil.deleteFile((String)sentinelName);
    }

    @After
    public void tearDown() throws Exception {
        if (this.process != null) {
            this.process.destroy();
        }
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }

    @Test
    public void testSimpleStartUp() throws Exception {
        String junkMessage = "x";
        this.connectionStatusSize = "0000000001";
        this.prepareSessionProcess();
        Assert.assertTrue((boolean)new String(this.httpRequest).startsWith("GET /?responder=socketCatcher&ticket=23"));
        this.socketOutput.write(junkMessage.getBytes());
        this.process.waitFor();
    }

    @Test
    public void testBadConnection() throws Exception {
        String errorMessage = "FAILURE";
        this.connectionStatusSize = "0000000007";
        this.prepareSessionProcess();
        this.socketOutput.write(errorMessage.getBytes());
        int exitValue = this.process.waitFor();
        String stdoutString = new String(this.stdoutBytes.toByteArray());
        Assert.assertTrue((exitValue != 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)stdoutString.contains(errorMessage));
    }

    @Test
    public void testNonTestInput() throws Exception {
        this.prepareSessionProcess();
        this.socketOutput.write("0000000020".getBytes());
        this.socketOutput.write("some untestable text".getBytes());
        this.socketOutput.flush();
        String sizeString = this.read(10);
        int size = Integer.parseInt(sizeString);
        String output = this.read(size);
        Assert.assertTrue((boolean)output.contains("Exception"));
        Assert.assertTrue((boolean)output.contains("Can't find tag: table"));
    }

    @Test
    public void testOneSimpleRun_Fail() throws Exception {
        String table = this.simpleTable("FailFixture");
        this.prepareSessionProcess();
        this.checkDocumentExecution(table);
        this.checkDocumentResults(0, 1, 0, 0);
        this.terminateSessionProcess();
        Assert.assertEquals((long)1L, (long)this.process.exitValue());
    }

    @Test
    public void testOneSimpleRun_Pass() throws Exception {
        String table = this.simpleTable("PassFixture");
        this.prepareSessionProcess();
        this.checkDocumentExecution(table);
        this.checkDocumentResults(1, 0, 0, 0);
        this.terminateSessionProcess();
        Assert.assertEquals((long)0L, (long)this.process.exitValue());
    }

    @Test
    public void testTwoSimpleRuns() throws Exception {
        String table = this.simpleTable("FailFixture");
        this.prepareSessionProcess();
        this.checkDocumentExecution(table);
        this.checkDocumentResults(0, 1, 0, 0);
        this.checkDocumentExecution(table);
        this.checkDocumentResults(0, 1, 0, 0);
        this.terminateSessionProcess();
        Assert.assertEquals((long)2L, (long)this.process.exitValue());
    }

    @Test
    public void testOneMulitiTableRun() throws Exception {
        String document = this.simpleTable("FailFixture") + this.simpleTable("FailFixture");
        this.prepareSessionProcess();
        FitProtocol.writeData((String)document, (OutputStream)this.socketOutput);
        this.checkForTwoClassAttributesInResponse();
        this.checkDocumentResults(0, 2, 0, 0);
        this.terminateSessionProcess();
        Assert.assertEquals((long)2L, (long)this.process.exitValue());
    }

    @Test
    public void testUnicodeCharacters() throws Exception {
        String table = "\uba80\uba81\uba82\uba83" + this.simpleTable("PassFixture");
        this.prepareSessionProcess();
        FitProtocol.writeData((String)table, (OutputStream)this.socketOutput);
        String response = this.readWholeResponse();
        RegexTestCase.assertSubString((String)"\uba80\uba81\uba82\uba83", (String)response);
        this.terminateSessionProcess();
    }

    @Test
    public void testExtraTextIdPrinted() throws Exception {
        String document = "<html>" + this.simpleTable("PassFixture") + "monkey" + this.simpleTable("PassFixture") + "</html>";
        this.prepareSessionProcess();
        FitProtocol.writeData((String)document, (OutputStream)this.socketOutput);
        String response = this.readWholeResponse();
        Assert.assertTrue((boolean)response.startsWith("<html>"));
        Assert.assertTrue((boolean)response.contains("monkey"));
        Assert.assertTrue((boolean)response.endsWith("</html>"));
        this.terminateSessionProcess();
    }

    @Test
    public void testFitParseExceptionDontCrashSuite() throws Exception {
        String input = "no table";
        this.prepareSessionProcess();
        this.checkDocumentExecution(input);
        this.checkDocumentResults(0, 0, 0, 1);
        this.checkDocumentExecution(this.simpleTable("PassFixture"));
        this.checkDocumentResults(1, 0, 0, 0);
        this.terminateSessionProcess();
        Assert.assertEquals((long)1L, (long)this.process.exitValue());
    }

    private String read(int n) throws Exception {
        return new StreamReader(this.socketInput).read(n);
    }

    private void prepareSessionProcess() throws Exception {
        this.checkSentinelToMakeSureThatFitServerIsNotRunning();
        String commandWithArguments = this.command() + " -s -v localhost " + 1634 + " 23";
        this.process = Runtime.getRuntime().exec(commandWithArguments);
        this.stdoutBytes = new ByteArrayOutputStream();
        this.watchForOutput(this.process.getInputStream(), new PrintStream(this.stdoutBytes));
        this.watchForOutput(this.process.getErrorStream(), System.err);
        this.establishConnection();
    }

    private void checkSentinelToMakeSureThatFitServerIsNotRunning() throws Exception {
        String sentinelName = FitServer.sentinelName((int)1634);
        File sentinel = new File(sentinelName);
        Assert.assertFalse((boolean)sentinel.exists());
    }

    private void establishConnection() throws Exception {
        this.serverSocket = new ServerSocket(1634);
        this.socket = null;
        this.listenForConnectionSocket();
        this.waitForConnectionSocket();
        Assert.assertNotNull((Object)this.socket);
        Assert.assertNotNull((Object)this.socketInput);
        Assert.assertNotNull((Object)this.socketOutput);
        this.httpRequest = new byte[52];
        this.socketInput.read(this.httpRequest);
        this.socketOutput.write(this.connectionStatusSize.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForConnectionSocket() throws InterruptedException {
        ServerSocket serverSocket = this.serverSocket;
        synchronized (serverSocket) {
            if (this.socket == null) {
                this.serverSocket.wait();
            }
        }
    }

    private void listenForConnectionSocket() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateSessionProcess() throws IOException, InterruptedException {
        try {
            this.socketOutput.write("0000000000".getBytes());
            this.process.waitFor();
        }
        finally {
            this.socketInput.close();
        }
    }

    private void watchForOutput(InputStream processOutput, PrintStream consoleOutput) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void checkDocumentResults(int right, int wrong, int ignored, int exceptions) throws Exception {
        Counts actual = FitProtocol.readCounts((StreamReader)new StreamReader(this.socketInput));
        Assert.assertEquals((long)right, (long)actual.right);
        Assert.assertEquals((long)wrong, (long)actual.wrong);
        Assert.assertEquals((long)ignored, (long)actual.ignores);
        Assert.assertEquals((long)exceptions, (long)actual.exceptions);
    }

    private void checkDocumentExecution(String table) throws Exception {
        FitProtocol.writeData((String)table, (OutputStream)this.socketOutput);
        this.checkForAttribute_class();
        this.checkSize("0000000000");
    }

    private void checkForAttribute_class() throws Exception {
        String output = this.readFromFitServer();
        Assert.assertTrue((String)"'class' attribute was not found", (boolean)output.contains("class="));
    }

    private String readFromFitServer() throws Exception {
        String readSize = this.read(10);
        int size = Integer.parseInt(readSize);
        String output = this.read(size);
        return output;
    }

    private void checkSize(String sizeString) throws Exception {
        RegexTestCase.assertEquals((String)sizeString, (String)this.read(10));
    }

    private void checkForTwoClassAttributesInResponse() throws Exception {
        String response = this.readWholeResponse();
        int first = response.indexOf("class");
        int second = response.indexOf("class", first + 1);
        Assert.assertTrue((first >= 0 && second > first ? 1 : 0) != 0);
    }

    private String readWholeResponse() throws Exception {
        StringBuffer buffer = new StringBuffer();
        String block = this.readFromFitServer();
        while (block.length() > 0) {
            buffer.append(block);
            block = this.readFromFitServer();
        }
        String response = buffer.toString();
        return response;
    }

    protected String command() {
        return "java -cp classes fit.FitServer";
    }

    protected String simpleTable(String fixtureName) {
        return "<table><tr><td>fitnesse.testutil." + fixtureName + "</td></tr>" + "</table>";
    }

    static /* synthetic */ ServerSocket access$000(FitServerTest x0) {
        return x0.serverSocket;
    }

    static /* synthetic */ Socket access$102(FitServerTest x0, Socket x1) {
        x0.socket = x1;
        return x0.socket;
    }

    static /* synthetic */ InputStream access$202(FitServerTest x0, InputStream x1) {
        x0.socketInput = x1;
        return x0.socketInput;
    }

    static /* synthetic */ Socket access$100(FitServerTest x0) {
        return x0.socket;
    }

    static /* synthetic */ OutputStream access$302(FitServerTest x0, OutputStream x1) {
        x0.socketOutput = x1;
        return x0.socketOutput;
    }
}

