/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.authentication.Authenticator;
import fitnesse.authentication.PromiscuousAuthenticator;
import fitnesse.components.Logger;
import fitnesse.components.SocketDealer;
import fitnesse.responders.PageFactory;
import fitnesse.responders.ResponderFactory;
import fitnesse.responders.run.RunningTestingTracker;
import fitnesse.wiki.WikiPage;
import java.io.File;

public class FitNesseContext {
    public static final String recentChangesDateFormat = "kk:mm:ss EEE, MMM dd, yyyy";
    public static final String rfcCompliantDateFormat = "EEE, d MMM yyyy HH:mm:ss Z";
    public static final String testResultsDirectoryName = "testResults";
    public final WikiPage root;
    public final SocketDealer socketDealer;
    public final RunningTestingTracker runningTestingTracker = new RunningTestingTracker();
    public final int port;
    public final String rootPath;
    public final String rootDirectoryName;
    public final ResponderFactory responderFactory;
    public final PageFactory pageFactory = new PageFactory(this);
    public final String defaultNewPageContent;
    public final Logger logger;
    public final Authenticator authenticator;
    public final String pageTheme;

    private FitNesseContext(WikiPage root, String rootPath, String rootDirectoryName, String pageTheme, String defaultNewPageContent, int port, SocketDealer socketDealer, Authenticator authenticator, Logger logger) {
        this.root = root;
        this.rootPath = rootPath != null ? rootPath : ".";
        this.rootDirectoryName = rootDirectoryName != null ? rootDirectoryName : "FitNesseRoot";
        this.pageTheme = pageTheme != null ? pageTheme : "fitnesse_straight";
        this.defaultNewPageContent = defaultNewPageContent != null ? defaultNewPageContent : "!contents -R2 -g -p -f -h";
        this.port = port >= 0 ? port : 80;
        this.socketDealer = socketDealer != null ? socketDealer : new SocketDealer();
        this.authenticator = authenticator != null ? authenticator : new PromiscuousAuthenticator();
        this.logger = logger;
        this.responderFactory = new ResponderFactory(this.getRootPagePath());
    }

    public String toString() {
        String endl = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t").append("port:              ").append(this.port).append(endl);
        buffer.append("\t").append("root page:         ").append(this.root).append(endl);
        buffer.append("\t").append("logger:            ").append(this.logger == null ? "none" : this.logger.toString()).append(endl);
        buffer.append("\t").append("authenticator:     ").append(this.authenticator).append(endl);
        buffer.append("\t").append("page factory:      ").append(this.pageFactory).append(endl);
        buffer.append("\t").append("page theme:        ").append(this.pageTheme).append(endl);
        return buffer.toString();
    }

    public File getTestHistoryDirectory() {
        return new File(String.format("%s/files/%s", this.getRootPagePath(), testResultsDirectoryName));
    }

    public String getTestProgressPath() {
        return String.format("%s/files/testProgress/", this.getRootPagePath());
    }

    public String getRootPagePath() {
        return String.format("%s/%s", this.rootPath, this.rootDirectoryName);
    }
}

