/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.authentication;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import junit.framework.TestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class SecureOperationTest
extends TestCase {
    private SecureReadOperation sro;
    private WikiPage root;
    FitNesseContext context;
    private MockRequest request;
    private PageCrawler crawler;
    private WikiPagePath parentPagePath;
    private WikiPagePath childPagePath;

    protected void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.sro = new SecureReadOperation();
        this.request = new MockRequest();
        this.crawler = this.root.getPageCrawler();
        this.parentPagePath = PathParser.parse((String)"ParentPage");
        this.childPagePath = PathParser.parse((String)"ChildPage");
    }

    public void testNormalPageDoesNotRequireAuthentication() throws Exception {
        String insecurePageName = "InsecurePage";
        WikiPagePath insecurePagePath = PathParser.parse((String)insecurePageName);
        this.crawler.addPage(this.root, insecurePagePath);
        this.request.setResource(insecurePageName);
        SecureOperationTest.assertFalse((boolean)this.sro.shouldAuthenticate(this.context, (Request)this.request));
    }

    public void testReadSecurePageRequresAuthentication() throws Exception {
        String securePageName = "SecurePage";
        WikiPagePath securePagePath = PathParser.parse((String)securePageName);
        WikiPage securePage = this.crawler.addPage(this.root, securePagePath);
        this.makeSecure(securePage);
        this.request.setResource(securePageName);
        SecureOperationTest.assertTrue((boolean)this.sro.shouldAuthenticate(this.context, (Request)this.request));
    }

    private void makeSecure(WikiPage securePage) throws Exception {
        PageData data = securePage.getData();
        data.setAttribute("secure-read");
        securePage.commit(data);
    }

    public void testChildPageOfSecurePageRequiresAuthentication() throws Exception {
        WikiPage parentPage = this.crawler.addPage(this.root, this.parentPagePath);
        this.makeSecure(parentPage);
        this.crawler.addPage(parentPage, this.childPagePath);
        this.request.setResource("ParentPage.ChildPage");
        SecureOperationTest.assertTrue((boolean)this.sro.shouldAuthenticate(this.context, (Request)this.request));
    }

    public void testNonExistentPageCanBeAuthenticated() throws Exception {
        this.request.setResource("NonExistentPage");
        SecureOperationTest.assertFalse((boolean)this.sro.shouldAuthenticate(this.context, (Request)this.request));
    }

    public void testParentOfNonExistentPageStillSetsPrivileges() throws Exception {
        WikiPage parentPage = this.crawler.addPage(this.root, this.parentPagePath);
        this.makeSecure(parentPage);
        this.request.setResource("ParentPage.NonExistentPage");
        SecureOperationTest.assertTrue((boolean)this.sro.shouldAuthenticate(this.context, (Request)this.request));
    }

    public void testChildPageIsRestricted() throws Exception {
        WikiPage parentPage = this.crawler.addPage(this.root, this.parentPagePath);
        WikiPage childPage = this.crawler.addPage(parentPage, this.childPagePath);
        this.makeSecure(childPage);
        this.request.setResource("ParentPage.ChildPage");
        SecureOperationTest.assertTrue((boolean)this.sro.shouldAuthenticate(this.context, (Request)this.request));
    }

    public void testBlankResource() throws Exception {
        this.request.setResource("");
        SecureOperationTest.assertFalse((boolean)this.sro.shouldAuthenticate(this.context, (Request)this.request));
    }
}

