/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.ContentReplacingSearchObserver;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ContentReplacingSearchObserverTest {
    private WikiPage wikiPage;
    private ContentReplacingSearchObserver observer;

    @Test
    public void replacesPageContent() throws Exception {
        this.wikiPage = this.createPageWithContent("simplePageContent");
        this.observer = this.simpleContentReplacer();
        this.observer.process(this.wikiPage);
        Assert.assertThat((Object)this.wikiPage, (Matcher)this.contentMatches("replacement"));
    }

    private ContentReplacingSearchObserver simpleContentReplacer() {
        return new ContentReplacingSearchObserver(".*", "replacement");
    }

    @Test
    public void replacesPageContentWithGroups() throws Exception {
        this.wikiPage = this.createPageWithContent("pattern1 some various text pattern2 pattern3");
        this.observer = new ContentReplacingSearchObserver("pattern1(.*)pattern2 pattern3", "replacement1$1replacement2 replacement3");
        this.observer.process(this.wikiPage);
        Assert.assertThat((Object)this.wikiPage, (Matcher)this.contentMatches("replacement1 some various text replacement2 replacement3"));
    }

    @Test
    public void replacesMultiLinedContent() throws Exception {
        this.wikiPage = this.createPageWithContent(this.multiLineContent());
        this.observer = new ContentReplacingSearchObserver("matching line", "replaced line");
        this.observer.process(this.wikiPage);
        Assert.assertThat((Object)this.wikiPage, (Matcher)this.contentMatches("line 1\nline 2\nline 3\nreplaced line\nline 5\nreplaced line\nline 7"));
    }

    private String multiLineContent() {
        return "line 1\nline 2\nline 3\nmatching line\nline 5\nmatching line\nline 7";
    }

    private WikiPage createPageWithContent(String pageContent) throws Exception {
        WikiPage wikiPage = InMemoryPage.makeRoot((String)"wikiPage");
        PageData pageData = wikiPage.getData();
        pageData.setContent(pageContent);
        wikiPage.commit(pageData);
        return wikiPage;
    }

    private Matcher<WikiPage> contentMatches(String simpleReplacement) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

