/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.LogData;
import fitnesse.components.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.TestCase;
import util.FileUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class LoggerTest
extends TestCase {
    private final String dirPath = "testLogs";
    private Logger l;
    private LogData ld;
    private String filename = "fitnesse20030306134205.log";
    private String logLine = "myHost - - [06/Mar/2003:13:42:05 -0100] \"request\" 42 666";
    private Locale saveLocale;

    public void setUp() throws Exception {
        this.saveLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        this.l = new Logger("testLogs");
        this.ld = new LogData();
        this.ld.host = "myHost";
        this.ld.requestLine = "request";
        this.ld.size = 666;
        this.ld.status = 42;
        TimeZone z = TimeZone.getTimeZone("GMT-1:00");
        this.ld.time = new GregorianCalendar(2003, 2, 6, 13, 42, 5);
        this.ld.time.setTimeZone(z);
    }

    public void tearDown() throws Exception {
        this.l.close();
        FileUtil.deleteFileSystemDirectory((String)"testLogs");
        Locale.setDefault(this.saveLocale);
    }

    public void testTimeZoneHandling() {
        GregorianCalendar calendar = new GregorianCalendar(2003, 0, 2, 3, 4, 5);
        ((Calendar)calendar).setTimeZone(TimeZone.getTimeZone("GMT+2"));
        SimpleDateFormat format = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss Z");
        DateFormat format2 = (DateFormat)((DateFormat)format).clone();
        format2.setTimeZone(((Calendar)calendar).getTimeZone());
        LoggerTest.assertEquals((String)"Jan 02, 2003 03:04:05 +0200", (String)format2.format(calendar.getTime()));
    }

    public void testConstruction() throws Exception {
        LoggerTest.assertEquals((String)"testLogs", (String)this.l.getDirectory().getName());
        File dir = new File("testLogs");
        LoggerTest.assertEquals((boolean)true, (boolean)dir.exists());
        LoggerTest.assertEquals((boolean)true, (boolean)dir.isDirectory());
    }

    public void testLogFormat() throws Exception {
        String line = this.l.formatLogLine(this.ld);
        LoggerTest.assertEquals((String)this.logLine, (String)line);
    }

    public void testLogFileName() throws Exception {
        String logName = Logger.makeLogFileName((Calendar)this.ld.time);
        LoggerTest.assertEquals((String)this.filename, (String)logName);
    }

    public void testLoggingOneLineInNewFile() throws Exception {
        this.l.log(this.ld);
        this.l.close();
        File dir = this.l.getDirectory();
        File file = new File(dir, this.filename);
        LoggerTest.assertTrue((boolean)file.exists());
        String contents = FileUtil.getFileContent((File)file);
        LoggerTest.assertEquals((String)(this.logLine + System.getProperty("line.separator")), (String)contents);
    }

    public void testLogSecondLineInSameFile() throws Exception {
        this.l.log(this.ld);
        LogData ld2 = (LogData)this.ld.clone();
        ld2.host = "newHost";
        this.l.log(ld2);
        File dir = this.l.getDirectory();
        File file = new File(dir, this.filename);
        BufferedReader br = new BufferedReader(new FileReader(file));
        LoggerTest.assertEquals((String)this.logLine, (String)br.readLine());
        LoggerTest.assertEquals((String)"newHost - - [06/Mar/2003:13:42:05 -0100] \"request\" 42 666", (String)br.readLine());
        LoggerTest.assertTrue((br.readLine() == null ? 1 : 0) != 0);
        br.close();
    }

    public void testLogLineInNewFile() throws Exception {
        LogData nextDay = (LogData)this.ld.clone();
        nextDay.time.add(5, 1);
        this.l.log(this.ld);
        this.l.log(nextDay);
        this.l.close();
        File firstFile = this.getLogFileFor(this.ld);
        File secondFile = this.getLogFileFor(nextDay);
        LoggerTest.assertTrue((boolean)firstFile.exists());
        LoggerTest.assertTrue((boolean)secondFile.exists());
        String firstContent = FileUtil.getFileContent((File)firstFile);
        LoggerTest.assertEquals((String)(this.l.formatLogLine(this.ld) + System.getProperty("line.separator")), (String)firstContent);
        String secondContent = FileUtil.getFileContent((File)secondFile);
        LoggerTest.assertEquals((String)(this.l.formatLogLine(nextDay) + System.getProperty("line.separator")), (String)secondContent);
    }

    public void testLoggingIncludesUsername() throws Exception {
        this.ld.username = "Joe";
        this.l.log(this.ld);
        this.l.close();
        File dir = this.l.getDirectory();
        File file = new File(dir, this.filename);
        LoggerTest.assertTrue((boolean)file.exists());
        String contents = FileUtil.getFileContent((File)file);
        this.logLine = "myHost - Joe [06/Mar/2003:13:42:05 -0100] \"request\" 42 666";
        LoggerTest.assertEquals((String)(this.logLine + System.getProperty("line.separator")), (String)contents);
    }

    private File getLogFileFor(LogData data) {
        return new File(this.l.getDirectory(), Logger.makeLogFileName((Calendar)data.time));
    }
}

