/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.ReferenceRenamer;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiWordReference;
import fitnesse.wikitext.parser.Alias;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.WikiWord;
import fitnesse.wikitext.parser.WikiWordPath;

public class PageReferenceRenamer
extends ReferenceRenamer {
    private WikiPage subjectPage;
    private String newName;

    public PageReferenceRenamer(WikiPage root, WikiPage subjectPage, String newName) {
        super(root);
        this.subjectPage = subjectPage;
        this.newName = newName;
    }

    public boolean visit(Symbol node) {
        try {
            String aliasReference;
            if (node.isType((SymbolType)WikiWord.symbolType)) {
                new WikiWordReference(this.currentPage, node.getContent()).wikiWordRenamePageIfReferenced(node, this.subjectPage, this.newName);
            } else if (node.isType((SymbolType)Alias.symbolType) && new WikiWordPath().findLength(aliasReference = node.childAt(1).childAt(0).getContent()) > 0) {
                new WikiWordReference(this.currentPage, aliasReference).wikiWordRenamePageIfReferenced(node.childAt(1).childAt(0), this.subjectPage, this.newName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return true;
    }

    public boolean visitChildren(Symbol node) {
        return !node.isType((SymbolType)Alias.symbolType);
    }
}

