/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.fixtures;

import fit.Fixture;
import fitnesse.fixtures.FitnesseFixtureContext;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;

public class PageBuilder
extends Fixture {
    private PrintWriter writer;
    private StringWriter stringWriter = new StringWriter();
    private String pageAttributes = null;

    public PageBuilder() {
        this.writer = new PrintWriter(this.stringWriter);
    }

    public void line(String line) {
        if (line.startsWith("\\")) {
            line = line.substring(1);
        }
        line = line.replace("&bar;", "|");
        line = line.replaceAll("&bang;", "!");
        line = line.replace("&dollar;", "$");
        this.writer.println(line);
    }

    public void page(String name) throws Exception {
        String content = this.stringWriter.toString();
        PageCrawler crawler = FitnesseFixtureContext.root.getPageCrawler();
        WikiPagePath path = PathParser.parse((String)name);
        WikiPage page = crawler.addPage(FitnesseFixtureContext.root, path, content);
        if (this.pageAttributes != null) {
            PageData data = page.getData();
            this.setAttributes(data);
            page.commit(data);
            this.pageAttributes = null;
        }
    }

    public void attributes(String attributes) {
        this.pageAttributes = attributes;
    }

    private void setAttributes(PageData data) throws Exception {
        StringTokenizer tokenizer = new StringTokenizer(this.pageAttributes, ",");
        while (tokenizer.hasMoreTokens()) {
            int equals;
            String nameValuePair = tokenizer.nextToken();
            if (nameValuePair.contains("!COMMA!")) {
                nameValuePair = nameValuePair.replace("!COMMA!", ",");
            }
            if ((equals = nameValuePair.indexOf("=")) < 0) {
                throw new Exception("Attribute must have form name=value");
            }
            String name = nameValuePair.substring(0, equals);
            String value = nameValuePair.substring(equals + 1);
            data.setAttribute(name, value);
        }
    }
}

