/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.responders.templateUtilities.ClasspathResourceLoader;
import fitnesse.responders.templateUtilities.EscapeDirective;
import fitnesse.responders.templateUtilities.HtmlPage;
import fitnesse.responders.templateUtilities.TraverseDirective;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class PageFactory {
    private static VelocityEngine velocityEngine = null;
    private FitNesseContext context;

    public PageFactory(FitNesseContext context) {
        this.context = context;
    }

    public HtmlPage newPage() {
        return new HtmlPage(this.getVelocityEngine(), "skeleton.vm", this.context.pageTheme);
    }

    public String render(VelocityContext context, String templateName) {
        StringWriter writer = new StringWriter();
        Template template = this.getVelocityEngine().getTemplate(templateName);
        template.merge((Context)context, (Writer)writer);
        return ((Object)writer).toString();
    }

    public String toString() {
        return this.getClass().getName();
    }

    public VelocityEngine getVelocityEngine() {
        if (velocityEngine == null) {
            Properties properties = new Properties();
            properties.setProperty("resource.loader", "file,themepath,classpath");
            properties.setProperty("file.resource.loader.path", String.format("%s/%s/files/fitnesse/templates", this.context.rootPath, this.context.rootDirectoryName));
            properties.setProperty("themepath.resource.loader.class", ClasspathResourceLoader.class.getName());
            properties.setProperty("themepath.resource.loader.base", String.format("/fitnesse/resources/%s/templates", this.context.pageTheme));
            properties.setProperty("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
            properties.setProperty("classpath.resource.loader.base", "/fitnesse/resources/templates");
            velocityEngine = new VelocityEngine();
            velocityEngine.init(properties);
            velocityEngine.loadDirective(TraverseDirective.class.getName());
            velocityEngine.loadDirective(EscapeDirective.class.getName());
        }
        return velocityEngine;
    }
}

