/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.responders.MockWikiImporterFactory;
import fitnesse.responders.WikiImportTestEventListener;
import fitnesse.responders.WikiImportTestEventListenerTest;
import fitnesse.responders.WikiImporterFactory;
import fitnesse.responders.run.TestResponder;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiImportProperty;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperty;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.StandardOutAndErrorRecorder;

public class WikiImportTestEventListenerTest {
    private WikiImportTestEventListener eventListener;
    private MockTestResponder testResponder;
    private MockSuiteResponder suiteResponder;
    private WikiPage pageOne;
    private MockWikiImporterFactory importerFactory;
    private WikiPage childOne;
    private WikiPage childTwo;
    private StandardOutAndErrorRecorder standardOutAndErrorRecorder;
    private String sentMessages = "";

    @Before
    public void setUp() throws Exception {
        this.standardOutAndErrorRecorder = new StandardOutAndErrorRecorder();
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        this.pageOne = root.addChildPage("PageOne");
        this.childOne = this.pageOne.addChildPage("ChildOne");
        this.childTwo = this.pageOne.addChildPage("ChildTwo");
        this.importerFactory = new MockWikiImporterFactory();
        this.eventListener = new WikiImportTestEventListener((WikiImporterFactory)this.importerFactory);
        this.testResponder = new MockTestResponder(this, null);
        this.suiteResponder = new MockSuiteResponder(this, null);
    }

    @After
    public void tearDown() {
        this.standardOutAndErrorRecorder.stopRecording(false);
    }

    @Test
    public void testRunWithTestingOnePage() throws Exception {
        this.addImportPropertyToPage(this.pageOne, false, true);
        PageData data = this.pageOne.getData();
        this.eventListener.notifyPreTest((TestResponder)this.testResponder, data);
        Assert.assertEquals((Object)"mock importer content", (Object)this.pageOne.getData().getContent());
        Assert.assertEquals((Object)"mock importer content", (Object)data.getContent());
        Assert.assertEquals((Object)"Updating imported content...done", (Object)this.sentMessages);
    }

    @Test
    public void testNoImportAnnouncementIfXmlFormat() throws Exception {
        this.testResponder.setXmlFormat();
        this.addImportPropertyToPage(this.pageOne, false, true);
        PageData data = this.pageOne.getData();
        this.eventListener.notifyPreTest((TestResponder)this.testResponder, data);
        Assert.assertEquals((Object)"", (Object)this.sentMessages);
    }

    @Test
    public void testRunWithTestingOnePageWithoutAutoUpdate() throws Exception {
        this.addImportPropertyToPage(this.pageOne, false, false);
        PageData data = this.pageOne.getData();
        this.eventListener.notifyPreTest((TestResponder)this.testResponder, data);
        Assert.assertEquals((Object)"", (Object)this.pageOne.getData().getContent());
        Assert.assertEquals((Object)"", (Object)data.getContent());
        Assert.assertEquals((Object)"", (Object)this.sentMessages);
    }

    @Test
    public void testErrorOccured() throws Exception {
        this.importerFactory.mockWikiImporter.fail = true;
        this.addImportPropertyToPage(this.pageOne, false, true);
        PageData data = this.pageOne.getData();
        this.eventListener.notifyPreTest((TestResponder)this.testResponder, data);
        Assert.assertEquals((Object)"", (Object)this.pageOne.getData().getContent());
        Assert.assertEquals((Object)"", (Object)data.getContent());
        Assert.assertEquals((Object)"Updating imported content...java.lang.Exception: blah", (Object)this.sentMessages);
    }

    @Test
    public void testRunWithSuiteFromRoot() throws Exception {
        this.addImportPropertyToPage(this.pageOne, true, true);
        PageData data = this.pageOne.getData();
        this.eventListener.notifyPreTest((TestResponder)this.suiteResponder, data);
        Assert.assertEquals((Object)"", (Object)this.pageOne.getData().getContent());
        Assert.assertEquals((Object)"mock importer content", (Object)this.childOne.getData().getContent());
        Assert.assertEquals((Object)"mock importer content", (Object)this.childTwo.getData().getContent());
        Assert.assertEquals((Object)"Updating imported content...done", (Object)this.sentMessages);
    }

    @Test
    public void testRunWithSuiteFromNonRoot() throws Exception {
        this.addImportPropertyToPage(this.pageOne, false, true);
        PageData data = this.pageOne.getData();
        this.eventListener.notifyPreTest((TestResponder)this.suiteResponder, data);
        Assert.assertEquals((Object)"mock importer content", (Object)this.pageOne.getData().getContent());
        Assert.assertEquals((Object)"mock importer content", (Object)this.childOne.getData().getContent());
        Assert.assertEquals((Object)"mock importer content", (Object)this.childTwo.getData().getContent());
        Assert.assertEquals((Object)"Updating imported content...done", (Object)this.sentMessages);
    }

    private void addImportPropertyToPage(WikiPage page, boolean isRoot, boolean autoUpdate) throws Exception {
        PageData data = page.getData();
        String sourceUrl = "http://localhost:1999/PageOne";
        WikiImportProperty importProps = new WikiImportProperty(sourceUrl);
        importProps.setRoot(isRoot);
        importProps.setAutoUpdate(autoUpdate);
        importProps.addTo((WikiPageProperty)data.getProperties());
        this.pageOne.commit(data);
    }

    private void AddMessage(String output) {
        this.sentMessages = this.sentMessages + output.replaceAll("<.*?>", "");
    }

    static /* synthetic */ void access$200(WikiImportTestEventListenerTest x0, String x1) {
        x0.AddMessage(x1);
    }
}

