/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.templateUtilities.HtmlPage;
import fitnesse.responders.templateUtilities.PageTitle;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.List;

public class DeletePageResponder
implements SecureResponder {
    private SimpleResponse response;
    private String qualifiedPageName;
    private WikiPagePath path;
    private FitNesseContext context;

    public Response makeResponse(FitNesseContext context, Request request) {
        this.context = context;
        this.intializeResponse(request);
        if (this.shouldNotDelete()) {
            this.response.redirect("FrontPage");
        } else {
            this.tryToDeletePage(request);
        }
        return this.response;
    }

    private void tryToDeletePage(Request request) {
        String confirmedString = (String)request.getInput("confirmed");
        if (!"yes".equalsIgnoreCase(confirmedString)) {
            this.response.setContent(this.buildConfirmationHtml(this.context.root, this.qualifiedPageName, this.context));
        } else {
            String nameOfPageToBeDeleted = this.path.last();
            this.path.removeNameFromEnd();
            WikiPage parentOfPageToBeDeleted = this.context.root.getPageCrawler().getPage(this.context.root, this.path);
            if (parentOfPageToBeDeleted != null) {
                parentOfPageToBeDeleted.removeChildPage(nameOfPageToBeDeleted);
            }
            this.redirect(this.path, this.response);
        }
    }

    private boolean shouldNotDelete() {
        return "FrontPage".equals(this.qualifiedPageName);
    }

    private void intializeResponse(Request request) {
        this.response = new SimpleResponse();
        this.qualifiedPageName = request.getResource();
        this.path = PathParser.parse((String)this.qualifiedPageName);
    }

    private void redirect(WikiPagePath path, SimpleResponse response) {
        String location = PathParser.render((WikiPagePath)path);
        if (location == null || location.length() == 0) {
            response.redirect("root");
        } else {
            response.redirect(location);
        }
    }

    private String buildConfirmationHtml(WikiPage root, String qualifiedPageName, FitNesseContext context) {
        HtmlPage html = context.pageFactory.newPage();
        String tags = "";
        if (context.root != null) {
            WikiPagePath path = PathParser.parse((String)qualifiedPageName);
            PageCrawler crawler = context.root.getPageCrawler();
            WikiPage wikiPage = crawler.getPage(root, path);
            if (wikiPage != null) {
                PageData pageData = wikiPage.getData();
                tags = pageData.getAttribute("Suites");
            }
        }
        html.setTitle("Delete Confirmation");
        html.setPageTitle(new PageTitle("Confirm Deletion", qualifiedPageName, "/", tags));
        this.makeMainContent(html, root, qualifiedPageName);
        html.setMainTemplate("deletePage");
        return html.html();
    }

    private void makeMainContent(HtmlPage html, WikiPage root, String qualifiedPageName) {
        WikiPagePath path = PathParser.parse((String)qualifiedPageName);
        WikiPage pageToDelete = root.getPageCrawler().getPage(root, path);
        List children = pageToDelete.getChildren();
        html.put("deleteSubPages", (Object)(children != null && !children.isEmpty() ? 1 : 0));
        html.put("pageName", (Object)qualifiedPageName);
    }

    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

