/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.FitNesseContext;
import fitnesse.http.MockRequest;
import fitnesse.http.MockResponseSender;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.responders.run.FitClientResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class FitClientResponderTest
extends RegexTestCase {
    private WikiPage root;
    private FitClientResponder responder;
    private MockRequest request;
    private FitNesseContext context;
    private Response response;
    private MockResponseSender sender;
    private static PageCrawler crawler;
    private static WikiPage suite;

    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.responder = new FitClientResponder();
        this.request = new MockRequest();
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        FitClientResponderTest.buildSuite((WikiPage)this.root);
    }

    public static void buildSuite(WikiPage root) throws Exception {
        crawler = root.getPageCrawler();
        suite = crawler.addPage(root, PathParser.parse((String)"SuitePage"), "!path classes\n");
        WikiPage page1 = crawler.addPage(suite, PathParser.parse((String)"TestPassing"), "!|fitnesse.testutil.PassFixture|\n");
        WikiPage page2 = crawler.addPage(suite, PathParser.parse((String)"TestFailing"), "!|fitnesse.testutil.FailFixture|\n");
        WikiPage page3 = crawler.addPage(suite, PathParser.parse((String)"TestAnotherFailing"), "!|fitnesse.testutil.FailFixture|\n");
        crawler.addPage(suite, PathParser.parse((String)"TestError"), "!|fitnesse.testutil.ErrorFixture|\n");
        crawler.addPage(suite, PathParser.parse((String)"TestIgnore"), "!|fitnesse.testutil.IgnoreFixture|\n");
        crawler.addPage(suite, PathParser.parse((String)"SomePage"), "This is just some page.");
        PageData data1 = page1.getData();
        PageData data2 = page2.getData();
        PageData data3 = page3.getData();
        data1.setAttribute("Suites", "skip,foo");
        data2.setAttribute("Suites", "bar,smoke");
        data3.setAttribute("Suites", "foo");
        page1.commit(data1);
        page2.commit(data2);
        page3.commit(data3);
    }

    public void tearDown() throws Exception {
    }

    public void testPageNotFound() throws Exception {
        String result = this.getResultFor("MissingPage");
        FitClientResponderTest.assertSubString((String)"MissingPage was not found", (String)result);
    }

    public void testOneTest() throws Exception {
        String result = this.getResultFor("SuitePage.TestPassing");
        FitClientResponderTest.assertEquals((String)"0000000000", (String)result.substring(0, 10));
        FitClientResponderTest.assertSubString((String)"PassFixture", (String)result);
    }

    public void testSuite() throws Exception {
        String result = this.getResultFor("SuitePage");
        FitClientResponderTest.assertEquals((String)"0000000000", (String)result.substring(0, 10));
        FitClientResponderTest.assertSubString((String)"PassFixture", (String)result);
        FitClientResponderTest.assertSubString((String)"FailFixture", (String)result);
        FitClientResponderTest.assertSubString((String)"ErrorFixture", (String)result);
        FitClientResponderTest.assertSubString((String)"IgnoreFixture", (String)result);
        FitClientResponderTest.assertNotSubString((String)"some page", (String)result);
    }

    public void testRelativePageNamesIncluded() throws Exception {
        String result = this.getResultFor("SuitePage");
        FitClientResponderTest.assertNotSubString((String)"SuitePage", (String)result);
        FitClientResponderTest.assertSubString((String)"TestPassing", (String)result);
        FitClientResponderTest.assertSubString((String)"TestFailing", (String)result);
        FitClientResponderTest.assertSubString((String)"TestError", (String)result);
        FitClientResponderTest.assertSubString((String)"TestIgnore", (String)result);
    }

    public void testPageThatIsNoATest() throws Exception {
        String result = this.getResultFor("SuitePage.SomePage");
        FitClientResponderTest.assertSubString((String)"SomePage is neither a Test page nor a Suite page.", (String)result);
    }

    private String getResultFor(String name) throws Exception {
        return this.getResultFor(name, false);
    }

    private String getResultFor(String name, boolean addPaths) throws Exception {
        this.request.setResource(name);
        if (addPaths) {
            this.request.addInput("includePaths", (Object)"blah");
        }
        this.response = this.responder.makeResponse(this.context, (Request)this.request);
        this.sender = new MockResponseSender();
        this.sender.doSending(this.response);
        String result = this.sender.sentData();
        return result;
    }

    public void testWithClasspathOnSuite() throws Exception {
        String result = this.getResultFor("SuitePage", true);
        FitClientResponderTest.assertTrue((boolean)result.startsWith("00000000000000000007classes"));
    }

    public void testWithClasspathOnTestInSuite() throws Exception {
        crawler.addPage(suite, PathParser.parse((String)"TestPage"), "!path jar.jar\n!path /some/dir/with/.class/files\n!|fitnesse.testutil.IgnoreFixture|\n");
        String result = this.getResultFor("SuitePage.TestPage", true);
        FitClientResponderTest.assertSubString((String)"classes", (String)result);
        FitClientResponderTest.assertSubString((String)"jar.jar", (String)result);
        FitClientResponderTest.assertSubString((String)"/some/dir/with/.class/files", (String)result);
    }
}

