/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.responders.run.JavaFormatter;
import fitnesse.responders.run.NullListener;
import fitnesse.responders.run.ResultsListener;
import fitnesse.responders.run.formatters.BaseFormatter;
import fitnesse.testsystems.CompositeExecutionLog;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.TimeMeasurement;

public class JavaFormatter
extends BaseFormatter {
    private String mainPageName;
    private boolean isSuite = true;
    private TestSummary totalSummary = new TestSummary();
    private List<String> visitedTestPages = new ArrayList();
    private Map<String, TestSummary> testSummaries = new HashMap();
    private ResultsRepository resultsRepository;
    private static final Map<String, JavaFormatter> allocatedInstances = new HashMap();
    private ResultsListener listener = new NullListener();

    public String getFullPath(WikiPage wikiPage) {
        return new WikiPagePath(wikiPage).toString();
    }

    public void newTestStarted(TestPage test, TimeMeasurement timeMeasurement) throws IOException {
        this.resultsRepository.open(this.getFullPath(test.getSourcePage()));
        this.listener.newTestStarted(test, timeMeasurement);
    }

    public void setExecutionLogAndTrackingId(String stopResponderId, CompositeExecutionLog log) {
    }

    public void testComplete(TestPage test, TestSummary testSummary, TimeMeasurement timeMeasurement) throws IOException {
        String fullPath = this.getFullPath(test.getSourcePage());
        this.visitedTestPages.add(fullPath);
        this.totalSummary.add(testSummary);
        this.testSummaries.put(fullPath, new TestSummary(testSummary));
        this.resultsRepository.close();
        this.isSuite = this.isSuite && !this.mainPageName.equals(fullPath);
        this.listener.testComplete(test, testSummary, timeMeasurement);
    }

    TestSummary getTestSummary(String testPath) {
        return (TestSummary)this.testSummaries.get(testPath);
    }

    public void testOutputChunk(String output) throws IOException {
        this.resultsRepository.write(output);
    }

    public void testSystemStarted(TestSystem testSystem, String testSystemName, String testRunner) {
    }

    public TestSummary getTotalSummary() {
        return this.totalSummary;
    }

    public void setTotalSummary(TestSummary testSummary) {
        this.totalSummary = testSummary;
    }

    public void setResultsRepository(ResultsRepository mockResultsRepository) {
        this.resultsRepository = mockResultsRepository;
    }

    JavaFormatter(String suiteName) {
        this.mainPageName = suiteName;
    }

    public static synchronized JavaFormatter getInstance(String testName) {
        JavaFormatter existing = (JavaFormatter)allocatedInstances.get(testName);
        if (existing != null) {
            return existing;
        }
        existing = new JavaFormatter(testName);
        allocatedInstances.put(testName, existing);
        return existing;
    }

    public void allTestingComplete(TimeMeasurement totalTimeMeasurement) throws IOException {
        if (this.isSuite) {
            this.writeSummary(this.mainPageName);
        }
        this.listener.allTestingComplete(totalTimeMeasurement);
    }

    public void writeSummary(String suiteName) throws IOException {
        this.resultsRepository.open(suiteName);
        this.resultsRepository.write(new TestResultsSummaryTable(this.visitedTestPages, this.testSummaries).toString());
        this.resultsRepository.close();
    }

    public void setListener(ResultsListener listener) {
        this.listener = listener;
    }

    public List<String> getTestsExecuted() {
        return this.visitedTestPages;
    }

    public static void dropInstance(String testName) {
        allocatedInstances.remove(testName);
    }
}

