/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.authentication.SecureTestOperation;
import fitnesse.http.ChunkedResponse;
import fitnesse.http.Response;
import fitnesse.responders.ChunkingResponder;
import fitnesse.responders.run.JavaFormatter;
import fitnesse.responders.run.MultipleTestsRunner;
import fitnesse.responders.run.ResultsListener;
import fitnesse.responders.run.SuiteContentsFinder;
import fitnesse.responders.run.TestEventListener;
import fitnesse.responders.run.TestResponder;
import fitnesse.responders.run.formatters.BaseFormatter;
import fitnesse.responders.run.formatters.CompositeFormatter;
import fitnesse.responders.run.formatters.PageHistoryFormatter;
import fitnesse.responders.run.formatters.PageInProgressFormatter;
import fitnesse.responders.run.formatters.TestTextFormatter;
import fitnesse.responders.run.formatters.XmlFormatter;
import fitnesse.responders.templateUtilities.HtmlPage;
import fitnesse.responders.templateUtilities.PageTitle;
import fitnesse.testsystems.TestSystem;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiImportProperty;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageActions;
import fitnesse.wiki.WikiPagePath;
import java.util.LinkedList;
import java.util.List;

public class TestResponder
extends ChunkingResponder
implements SecureResponder {
    private static final LinkedList<TestEventListener> eventListeners = new LinkedList();
    protected PageData data;
    protected CompositeFormatter formatters = new CompositeFormatter();
    protected boolean isInteractive = false;
    private volatile boolean isClosed = false;
    private boolean fastTest = false;
    private boolean remoteDebug = false;
    protected TestSystem testSystem;
    int exitCode;

    protected void doSending() throws Exception {
        this.checkArguments();
        this.data = this.page.getData();
        this.createFormatters();
        if (this.isInteractive) {
            this.makeHtml().render(this.response.getWriter());
        } else {
            this.doExecuteTests();
        }
        this.closeHtmlResponse(this.exitCode);
    }

    public void doExecuteTests() {
        this.sendPreTestNotification();
        this.performExecution();
        this.exitCode = this.formatters.getErrorCount();
    }

    private HtmlPage makeHtml() {
        PageCrawler pageCrawler = this.page.getPageCrawler();
        WikiPagePath fullPath = pageCrawler.getFullPath(this.page);
        String fullPathName = PathParser.render((WikiPagePath)fullPath);
        HtmlPage htmlPage = this.context.pageFactory.newPage();
        htmlPage.setTitle(this.getTitle() + ": " + fullPathName);
        htmlPage.setPageTitle(new PageTitle(this.getTitle(), fullPath, this.data.getAttribute("Suites")));
        htmlPage.setNavTemplate("testNav.vm");
        htmlPage.put("actions", (Object)new WikiPageActions(this.page));
        htmlPage.setMainTemplate(this.mainTemplate());
        htmlPage.put("testExecutor", (Object)new TestExecutor(this));
        htmlPage.setFooterTemplate("wikiFooter.vm");
        htmlPage.put("footerContent", (Object)new WikiPageFooterRenderer(this));
        htmlPage.setErrorNavTemplate("errorNavigator");
        htmlPage.put("errorNavOnDocumentReady", (Object)false);
        WikiImportProperty.handleImportProperties((HtmlPage)htmlPage, (WikiPage)this.page);
        return htmlPage;
    }

    protected void checkArguments() {
        this.fastTest |= this.request.hasInput("debug");
        this.remoteDebug |= this.request.hasInput("remote_debug");
    }

    protected void createFormatters() {
        if (this.response.isXmlFormat()) {
            this.addXmlFormatter();
        } else if (this.response.isTextFormat()) {
            this.addTextFormatter();
        } else if (this.response.isJavaFormat()) {
            this.addJavaFormatter();
        } else {
            this.addHtmlFormatter();
            this.isInteractive = true;
        }
        if (!this.request.hasInput("nohistory")) {
            this.addTestHistoryFormatter();
        }
        this.addTestInProgressFormatter();
    }

    protected String getTitle() {
        return "Test Results";
    }

    protected String mainTemplate() {
        return "testPage";
    }

    void addXmlFormatter() {
        1 writerSource = new /* Unavailable Anonymous Inner Class!! */;
        this.formatters.add((BaseFormatter)new XmlFormatter(this.context, this.page, (XmlFormatter.WriterFactory)writerSource));
    }

    void addTextFormatter() {
        this.formatters.add((BaseFormatter)new TestTextFormatter(this.response));
    }

    void addJavaFormatter() {
        this.formatters.add((BaseFormatter)JavaFormatter.getInstance((String)new WikiPagePath(this.page).toString()));
    }

    void addHtmlFormatter() {
        2 formatter = new /* Unavailable Anonymous Inner Class!! */;
        this.formatters.add((BaseFormatter)formatter);
    }

    protected void addTestHistoryFormatter() {
        HistoryWriterFactory writerFactory = new HistoryWriterFactory();
        this.formatters.add((BaseFormatter)new PageHistoryFormatter(this.context, this.page, (XmlFormatter.WriterFactory)writerFactory));
    }

    protected void addTestInProgressFormatter() {
        this.formatters.add((BaseFormatter)new PageInProgressFormatter(this.context, this.page));
    }

    protected void sendPreTestNotification() {
        for (TestEventListener eventListener : eventListeners) {
            eventListener.notifyPreTest(this, this.data);
        }
    }

    protected void performExecution() {
        List test2run = new SuiteContentsFinder(this.page, null, this.root).makePageListForSingleTest();
        MultipleTestsRunner runner = new MultipleTestsRunner(test2run, this.context, this.page, (ResultsListener)this.formatters);
        runner.setFastTest(this.fastTest);
        runner.setDebug(this.isRemoteDebug());
        if (this.isEmpty(this.page)) {
            this.formatters.addMessageForBlankHtml();
        }
        runner.executeTestPages();
    }

    private boolean isEmpty(WikiPage page) {
        return page.getData().getContent().length() == 0;
    }

    public SecureOperation getSecureOperation() {
        return new SecureTestOperation();
    }

    public static void registerListener(TestEventListener listener) {
        eventListeners.add(listener);
    }

    public void setFastTest(boolean fastTest) {
        this.fastTest = fastTest;
    }

    public boolean isFastTest() {
        return this.fastTest;
    }

    public void addToResponse(String output) {
        if (!this.isClosed()) {
            this.response.add(output);
        }
    }

    synchronized boolean isClosed() {
        return this.isClosed;
    }

    synchronized void setClosed() {
        this.isClosed = true;
    }

    void closeHtmlResponse(int exitCode) {
        if (!this.isClosed()) {
            this.setClosed();
            this.response.closeChunks();
            this.response.addTrailingHeader("Exit-Code", String.valueOf(exitCode));
            this.response.closeTrailer();
            this.response.close();
        }
    }

    void closeHtmlResponse() {
        if (!this.isClosed()) {
            this.setClosed();
            this.response.closeChunks();
            this.response.close();
        }
    }

    boolean isRemoteDebug() {
        return this.remoteDebug;
    }

    public Response getResponse() {
        return this.response;
    }

    static /* synthetic */ ChunkedResponse access$000(TestResponder x0) {
        return x0.response;
    }
}

