/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.authentication.SecureTestOperation;
import fitnesse.http.MockRequest;
import fitnesse.http.MockResponseSender;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.responders.run.MockTestEventListener;
import fitnesse.responders.run.TestEventListener;
import fitnesse.responders.run.TestResponder;
import fitnesse.responders.run.TestResponderTest;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.fit.FitSocketReceiver;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wikitext.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import util.Clock;
import util.DateAlteringClock;
import util.DateTimeUtil;
import util.FileUtil;
import util.RegexTestCase;
import util.XmlUtil;

public class TestResponderTest {
    private static final String TEST_TIME = "12/5/2008 01:19:00";
    private WikiPage root;
    private MockRequest request;
    private TestResponder responder;
    private FitNesseContext context;
    private Response response;
    private MockResponseSender sender;
    private WikiPage testPage;
    private String results;
    private FitSocketReceiver receiver;
    private WikiPage errorLogsParentPage;
    private PageCrawler crawler;
    private File xmlResultsFile;
    private XmlChecker xmlChecker = new XmlChecker(this);

    @Before
    public void setUp() throws Exception {
        File testDir = new File("TestDir");
        testDir.mkdir();
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        this.errorLogsParentPage = this.crawler.addPage(this.root, PathParser.parse((String)"ErrorLogs"));
        this.request = new MockRequest();
        this.responder = new TestResponder();
        this.responder.setFastTest(true);
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.receiver = new FitSocketReceiver(0, this.context.socketDealer);
        this.context = FitNesseUtil.makeTestContext((FitNesseContext)this.context, (int)this.receiver.receiveSocket());
        new DateAlteringClock(DateTimeUtil.getDateFromString((String)TEST_TIME)).advanceMillisOnEachQuery();
    }

    @After
    public void tearDown() throws Exception {
        this.receiver.close();
        FitNesseUtil.destroyTestContext();
        Clock.restoreDefaultClock();
    }

    @Test
    public void testIsValidHtml() throws Exception {
        this.doSimpleRun(this.passFixtureTable());
        RegexTestCase.assertSubString((String)"<!DOCTYPE html>", (String)this.results);
        RegexTestCase.assertSubString((String)"</html>", (String)this.results);
        RegexTestCase.assertSubString((String)"<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>", (String)this.results);
    }

    @Test
    public void testHead() throws Exception {
        this.doSimpleRun(this.passFixtureTable());
        RegexTestCase.assertSubString((String)"<div id=\"test-summary\">Running Tests ...</div>", (String)this.results);
    }

    @Test
    public void testSimpleRun() throws Exception {
        this.doSimpleRun(this.passFixtureTable());
        RegexTestCase.assertSubString((String)this.testPage.getName(), (String)this.results);
        RegexTestCase.assertSubString((String)"Test Results", (String)this.results);
        RegexTestCase.assertSubString((String)"class", (String)this.results);
        RegexTestCase.assertNotSubString((String)"ClassNotFoundException", (String)this.results);
    }

    private void doSimpleRun(String fixtureTable) throws Exception {
        this.doSimpleRunWithTags(fixtureTable, null);
    }

    private void doSimpleRunWithTags(String fixtureTable, String tags) throws Exception {
        String simpleRunPageName = "TestPage";
        this.testPage = this.crawler.addPage(this.root, PathParser.parse((String)simpleRunPageName), this.classpathWidgets() + fixtureTable);
        if (tags != null) {
            PageData pageData = this.testPage.getData();
            pageData.setAttribute("Suites", tags);
            this.testPage.commit(pageData);
        }
        this.request.setResource(this.testPage.getName());
        this.response = this.responder.makeResponse(this.context, (Request)this.request);
        this.sender = new MockResponseSender();
        this.sender.doSending(this.response);
        this.results = this.sender.sentData();
    }

    @Test
    public void testEmptyTestPage() throws Exception {
        PageData data = this.root.getData();
        data.setContent(this.classpathWidgets());
        this.root.commit(data);
        this.testPage = this.crawler.addPage(this.root, PathParser.parse((String)"EmptyTestPage"));
        this.request.setResource(this.testPage.getName());
        this.response = this.responder.makeResponse(this.context, (Request)this.request);
        this.sender = new MockResponseSender();
        this.sender.doSending(this.response);
        this.sender.sentData();
        WikiPagePath errorLogPath = PathParser.parse((String)"ErrorLogs.EmptyTestPage");
        WikiPage errorLogPage = this.crawler.getPage(this.root, errorLogPath);
        String errorLogContent = errorLogPage.getData().getContent();
        RegexTestCase.assertNotSubString((String)"Exception", (String)errorLogContent);
    }

    @Test
    public void testFitSocketGetsClosed() throws Exception {
        this.doSimpleRun(this.passFixtureTable());
        Assert.assertTrue((boolean)this.receiver.socket.isClosed());
    }

    @Test
    public void testStandardOutput() throws Exception {
        this.responder.setFastTest(false);
        String content = this.classpathWidgets() + this.outputWritingTable("output1") + this.outputWritingTable("output2") + this.outputWritingTable("output3");
        String errorLogContent = this.doRunAndGetErrorLog(content);
        RegexTestCase.assertHasRegexp((String)"output1", (String)errorLogContent);
        RegexTestCase.assertHasRegexp((String)"output2", (String)errorLogContent);
        RegexTestCase.assertHasRegexp((String)"output3", (String)errorLogContent);
    }

    @Test
    public void testErrorOutput() throws Exception {
        this.responder.setFastTest(false);
        String content = this.classpathWidgets() + this.errorWritingTable("error1") + this.errorWritingTable("error2") + this.errorWritingTable("error3");
        String errorLogContent = this.doRunAndGetErrorLog(content);
        RegexTestCase.assertHasRegexp((String)"error1", (String)errorLogContent);
        RegexTestCase.assertHasRegexp((String)"error2", (String)errorLogContent);
        RegexTestCase.assertHasRegexp((String)"error3", (String)errorLogContent);
    }

    private String doRunAndGetErrorLog(String content) throws Exception {
        WikiPage testPage = this.crawler.addPage(this.root, PathParser.parse((String)"TestPage"), content);
        this.request.setResource(testPage.getName());
        Response response = this.responder.makeResponse(this.context, (Request)this.request);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending(response);
        String results = sender.sentData();
        RegexTestCase.assertHasRegexp((String)"ErrorLog", (String)results);
        WikiPage errorLog = this.errorLogsParentPage.getChildPage(testPage.getName());
        return errorLog.getData().getContent();
    }

    @Test
    public void testHasExitValueHeader() throws Exception {
        WikiPage testPage = this.crawler.addPage(this.root, PathParser.parse((String)"TestPage"), this.classpathWidgets() + this.passFixtureTable());
        this.request.setResource(testPage.getName());
        Response response = this.responder.makeResponse(this.context, (Request)this.request);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending(response);
        String results = sender.sentData();
        RegexTestCase.assertSubString((String)"Exit-Code: 0", (String)results);
    }

    @Test
    public void exitCodeIsCountOfErrors() throws Exception {
        this.doSimpleRun(this.failFixtureTable());
        RegexTestCase.assertSubString((String)"Exit-Code: 1", (String)this.results);
    }

    @Test
    public void pageHistoryLinkIsIncluded() throws Exception {
        this.responder.turnOffChunking();
        this.doSimpleRun(this.passFixtureTable());
        RegexTestCase.assertSubString((String)"href=\"TestPage?pageHistory\">", (String)this.results);
        RegexTestCase.assertSubString((String)"Page History", (String)this.results);
    }

    @Test
    public void testFixtureThatCrashes() throws Exception {
        this.responder.setFastTest(false);
        WikiPage testPage = this.crawler.addPage(this.root, PathParser.parse((String)"TestPage"), this.classpathWidgets() + this.crashFixtureTable());
        this.request.setResource(testPage.getName());
        Response response = this.responder.makeResponse(this.context, (Request)this.request);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending(response);
        String results = sender.sentData();
        RegexTestCase.assertSubString((String)"ErrorLog", (String)results);
    }

    @Test
    public void testResultsIncludeActions() throws Exception {
        this.doSimpleRun(this.passFixtureTable());
        RegexTestCase.assertSubString((String)"<nav>", (String)this.results);
    }

    @Test
    public void testResultsHaveHeaderAndFooter() throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"PageHeader"), "HEADER");
        this.crawler.addPage(this.root, PathParser.parse((String)"PageFooter"), "FOOTER");
        this.doSimpleRun(this.passFixtureTable());
        RegexTestCase.assertSubString((String)"HEADER", (String)this.results);
        RegexTestCase.assertSubString((String)"FOOTER", (String)this.results);
    }

    @Test
    public void testExecutionStatusAppears() throws Exception {
        this.doSimpleRun(this.passFixtureTable());
        RegexTestCase.assertHasRegexp((String)"Tests Executed OK", (String)this.results);
    }

    @Test
    public void simpleXmlFormat() throws Exception {
        this.responder.turnOffChunking();
        this.request.addInput("format", (Object)"xml");
        this.doSimpleRun(this.passFixtureTable());
        this.xmlChecker.assertFitPassFixtureXmlReportIsCorrect();
    }

    @Test
    public void noHistory_skipsHistoryFormatter() throws Exception {
        this.ensureXmlResultFileDoesNotExist(new TestSummary(2, 0, 0, 0));
        this.request.addInput("nohistory", (Object)"true");
        this.doSimpleRun(this.simpleSlimDecisionTable());
        Assert.assertFalse((boolean)this.xmlResultsFile.exists());
    }

    private String slimDecisionTable() {
        return "!define TEST_SYSTEM {slim}\n|!-DT:fitnesse.slim.test.TestSlim-!|\n|string|get string arg?|\n|right|wrong|\n|wow|wow|\n";
    }

    @Test
    public void slimXmlFormat() throws Exception {
        this.responder.turnOffChunking();
        this.request.addInput("format", (Object)"xml");
        this.ensureXmlResultFileDoesNotExist(new TestSummary(1, 1, 0, 0));
        this.doSimpleRunWithTags(this.slimDecisionTable(), "zoo");
        Document xmlFromFile = this.getXmlFromFileAndDeleteFile();
        this.xmlChecker.assertXmlReportOfSlimDecisionTableWithZooTagIsCorrect();
        this.xmlChecker.assertXmlHeaderIsCorrect(xmlFromFile);
        this.xmlChecker.assertXmlReportOfSlimDecisionTableWithZooTagIsCorrect();
    }

    @Test
    public void slimXmlFormatGivesErrorCountAsExitCode() throws Exception {
        this.request.addInput("format", (Object)"xml");
        this.ensureXmlResultFileDoesNotExist(new TestSummary(1, 1, 0, 0));
        this.doSimpleRunWithTags(this.slimDecisionTable(), "zoo");
        this.getXmlFromFileAndDeleteFile();
        RegexTestCase.assertSubString((String)"Exit-Code: 1", (String)this.results);
    }

    private void ensureXmlResultFileDoesNotExist(TestSummary counts) {
        String resultsFileName = String.format("%s/TestPage/20081205011900_%d_%d_%d_%d.xml", this.context.getTestHistoryDirectory(), counts.getRight(), counts.getWrong(), counts.getIgnores(), counts.getExceptions());
        this.xmlResultsFile = new File(resultsFileName);
        if (this.xmlResultsFile.exists()) {
            FileUtil.deleteFile((File)this.xmlResultsFile);
        }
    }

    private Document getXmlFromFileAndDeleteFile() throws Exception {
        Assert.assertTrue((String)this.xmlResultsFile.getAbsolutePath(), (boolean)this.xmlResultsFile.exists());
        FileInputStream xmlResultsStream = new FileInputStream(this.xmlResultsFile);
        Document xmlDoc = XmlUtil.newDocument((InputStream)xmlResultsStream);
        xmlResultsStream.close();
        FileUtil.deleteFile((File)this.xmlResultsFile);
        return xmlDoc;
    }

    @Test
    public void slimScenarioXmlFormat() throws Exception {
        this.responder.turnOffChunking();
        this.request.addInput("format", (Object)"xml");
        this.doSimpleRun("!define TEST_SYSTEM {slim}\n\n!|scenario|f|a|\n|check|echo int|@a|@a|\n\n!|script|fitnesse.slim.test.TestSlim|\n\n!|f|\n|a|\n|1|\n|2|\n");
        this.xmlChecker.assertXmlReportOfSlimScenarioTableIsCorrect();
    }

    @Test
    public void simpleTextFormatForPassingTest() throws Exception {
        this.request.addInput("format", (Object)"text");
        this.doSimpleRun(this.passFixtureTable());
        Assert.assertEquals((Object)"text/text", (Object)this.response.getContentType());
        Assert.assertTrue((boolean)this.results.contains("\n. "));
        Assert.assertTrue((boolean)this.results.contains("R:1    W:0    I:0    E:0    TestPage\t(TestPage)"));
        Assert.assertTrue((boolean)this.results.contains("1 Tests,\t0 Failures"));
    }

    @Test
    public void simpleTextFormatForFailingTest() throws Exception {
        this.request.addInput("format", (Object)"text");
        this.doSimpleRun(this.failFixtureTable());
        Assert.assertEquals((Object)"text/text", (Object)this.response.getContentType());
        Assert.assertTrue((boolean)this.results.contains("\nF "));
        Assert.assertTrue((boolean)this.results.contains("R:0    W:1    I:0    E:0    TestPage\t(TestPage)"));
        Assert.assertTrue((boolean)this.results.contains("1 Tests,\t1 Failures"));
    }

    @Test
    public void simpleTextFormatForErrorTest() throws Exception {
        this.request.addInput("format", (Object)"text");
        this.doSimpleRun(this.errorFixtureTable());
        Assert.assertEquals((Object)"text/text", (Object)this.response.getContentType());
        Assert.assertTrue((boolean)this.results.contains("\nX "));
        Assert.assertTrue((boolean)this.results.contains("R:0    W:0    I:0    E:1    TestPage\t(TestPage)"));
        Assert.assertTrue((boolean)this.results.contains("1 Tests,\t1 Failures"));
    }

    @Test
    public void testExecutionStatusOk() throws Exception {
        this.doSimpleRun(this.passFixtureTable());
        Assert.assertTrue((boolean)this.results.contains(">Tests Executed OK<"));
        Assert.assertTrue((boolean)this.results.contains("\\\"ok\\\""));
    }

    @Test
    public void debugTest() throws Exception {
        this.responder.setFastTest(false);
        this.request.addInput("debug", (Object)"");
        this.doSimpleRun(this.passFixtureTable());
        Assert.assertTrue((boolean)this.results.contains(">Tests Executed OK<"));
        Assert.assertTrue((boolean)this.results.contains("\\\"ok\\\""));
        Assert.assertTrue((String)"should be fast test", (boolean)this.responder.isFastTest());
    }

    @Test
    public void testExecutionStatusOutputCaptured() throws Exception {
        this.responder.setFastTest(false);
        this.doSimpleRun(this.outputWritingTable("blah"));
        Assert.assertTrue((boolean)this.results.contains(">Output Captured<"));
        Assert.assertTrue((boolean)this.results.contains("\\\"output\\\""));
    }

    @Test
    public void testExecutionStatusError() throws Exception {
        this.responder.setFastTest(false);
        this.doSimpleRun(this.crashFixtureTable());
        Assert.assertTrue((boolean)this.results.contains(">Errors Occurred<"));
        Assert.assertTrue((boolean)this.results.contains("\\\"error\\\""));
    }

    @Test
    public void testExecutionStatusErrorHasPriority() throws Exception {
        this.responder.setFastTest(false);
        this.doSimpleRun(this.errorWritingTable("blah") + this.crashFixtureTable());
        Assert.assertTrue((boolean)this.results.contains(">Errors Occurred<"));
    }

    @Test
    public void testTestSummaryAppears() throws Exception {
        this.doSimpleRun(this.passFixtureTable());
        RegexTestCase.assertHasRegexp((String)RegexTestCase.divWithIdAndContent((String)"test-summary", (String)".*?"), (String)this.results);
    }

    @Test
    public void testTestSummaryInformationAppears() throws Exception {
        this.doSimpleRun(this.passFixtureTable());
        RegexTestCase.assertHasRegexp((String)"<script>.*?document\\.getElementById\\(\"test-summary\"\\)\\.innerHTML = \".*?Assertions:.*?\";.*?</script>", (String)this.results);
        RegexTestCase.assertHasRegexp((String)"<script>.*?document\\.getElementById\\(\"test-summary\"\\)\\.className = \".*?\";.*?</script>", (String)this.results);
    }

    @Test
    public void testTestSummaryHasRightClass() throws Exception {
        this.doSimpleRun(this.passFixtureTable());
        RegexTestCase.assertHasRegexp((String)"<script>.*?document\\.getElementById\\(\"test-summary\"\\)\\.className = \"pass\";.*?</script>", (String)this.results);
    }

    @Test
    public void testTestHasStopped() throws Exception {
        String semaphoreName = "testTestHasStopped.semaphore";
        File semaphore = new File(semaphoreName);
        if (semaphore.exists()) {
            semaphore.delete();
        }
        new Thread(this.makeStopTestsRunnable(semaphore)).start();
        this.doSimpleRun(this.createAndWaitFixture(semaphoreName));
        RegexTestCase.assertHasRegexp((String)"Testing was interupted", (String)this.results);
        semaphore.delete();
    }

    private String createAndWaitFixture(String semaphoreName) {
        return "!define TEST_SYSTEM {slim}\n!|fitnesse.testutil.CreateFileAndWaitFixture|" + semaphoreName + "|\n";
    }

    private Runnable makeStopTestsRunnable(File semaphore) {
        return new WaitForSemaphoreThenStopProcesses(this, semaphore);
    }

    @Test
    public void testAuthentication_RequiresTestPermission() throws Exception {
        Assert.assertTrue((boolean)(this.responder instanceof SecureResponder));
        SecureOperation operation = this.responder.getSecureOperation();
        Assert.assertEquals(SecureTestOperation.class, operation.getClass());
    }

    @Test
    public void testNotifyListeners() throws Exception {
        MockTestEventListener listener1 = new MockTestEventListener();
        MockTestEventListener listener2 = new MockTestEventListener();
        TestResponder.registerListener((TestEventListener)listener1);
        TestResponder.registerListener((TestEventListener)listener2);
        this.doSimpleRun(this.passFixtureTable());
        Assert.assertEquals((Object)true, (Object)listener1.gotPreTestNotification);
        Assert.assertEquals((Object)true, (Object)listener2.gotPreTestNotification);
    }

    @Test
    public void testSuiteSetUpAndTearDownIsCalledIfSingleTestIsRun() throws Exception {
        this.responder.setFastTest(false);
        WikiPage suitePage = this.crawler.addPage(this.root, PathParser.parse((String)"TestSuite"), this.classpathWidgets());
        WikiPage testPage = this.crawler.addPage(suitePage, PathParser.parse((String)"TestPage"), this.outputWritingTable("Output of TestPage"));
        this.crawler.addPage(suitePage, PathParser.parse((String)"SuiteSetUp"), this.outputWritingTable("Output of SuiteSetUp"));
        this.crawler.addPage(suitePage, PathParser.parse((String)"SuiteTearDown"), this.outputWritingTable("Output of SuiteTearDown"));
        PageData data = testPage.getData();
        WikiPageProperties properties = data.getProperties();
        properties.set("Suites", "Test Page tags");
        testPage.commit(data);
        WikiPagePath testPagePath = this.crawler.getFullPath(testPage);
        String resource = PathParser.render((WikiPagePath)testPagePath);
        this.request.setResource(resource);
        Response response = this.responder.makeResponse(this.context, (Request)this.request);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending(response);
        this.results = sender.sentData();
        Assert.assertTrue((boolean)this.results.contains(">Output Captured<"));
        RegexTestCase.assertHasRegexp((String)"ErrorLog", (String)this.results);
        RegexTestCase.assertSubString((String)"Test Page tags", (String)this.results);
        WikiPage errorLog = this.crawler.getPage(this.errorLogsParentPage, testPagePath);
        String errorLogContent = errorLog.getData().getContent();
        RegexTestCase.assertHasRegexp((String)"Output of SuiteSetUp", (String)errorLogContent);
        RegexTestCase.assertHasRegexp((String)"Output of TestPage", (String)errorLogContent);
        RegexTestCase.assertHasRegexp((String)"Output of SuiteTearDown", (String)errorLogContent);
    }

    @Test
    public void testSuiteSetUpDoesNotIncludeSetUp() throws Exception {
        this.responder.setFastTest(false);
        WikiPage suitePage = this.crawler.addPage(this.root, PathParser.parse((String)"TestSuite"), this.classpathWidgets());
        WikiPage testPage = this.crawler.addPage(suitePage, PathParser.parse((String)"TestPage"), this.outputWritingTable("Output of TestPage"));
        this.crawler.addPage(suitePage, PathParser.parse((String)"SuiteSetUp"), this.outputWritingTable("Output of SuiteSetUp"));
        this.crawler.addPage(suitePage, PathParser.parse((String)"SetUp"), this.outputWritingTable("Output of SetUp"));
        WikiPagePath testPagePath = this.crawler.getFullPath(testPage);
        String resource = PathParser.render((WikiPagePath)testPagePath);
        this.request.setResource(resource);
        Response response = this.responder.makeResponse(this.context, (Request)this.request);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending(response);
        this.results = sender.sentData();
        WikiPage errorLog = this.crawler.getPage(this.errorLogsParentPage, testPagePath);
        String errorLogContent = errorLog.getData().getContent();
        this.assertMessagesOccurInOrder(errorLogContent, new String[]{"Output of SuiteSetUp", "Output of SetUp", "Output of TestPage"});
        this.assertMessageHasJustOneOccurrenceOf(errorLogContent, "Output of SetUp");
    }

    @Test
    public void testSuiteTearDownDoesNotIncludeTearDown() throws Exception {
        this.responder.setFastTest(false);
        WikiPage suitePage = this.crawler.addPage(this.root, PathParser.parse((String)"TestSuite"), this.classpathWidgets());
        WikiPage testPage = this.crawler.addPage(suitePage, PathParser.parse((String)"TestPage"), this.outputWritingTable("Output of TestPage"));
        this.crawler.addPage(suitePage, PathParser.parse((String)"SuiteTearDown"), this.outputWritingTable("Output of SuiteTearDown"));
        this.crawler.addPage(suitePage, PathParser.parse((String)"TearDown"), this.outputWritingTable("Output of TearDown"));
        WikiPagePath testPagePath = this.crawler.getFullPath(testPage);
        String resource = PathParser.render((WikiPagePath)testPagePath);
        this.request.setResource(resource);
        Response response = this.responder.makeResponse(this.context, (Request)this.request);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending(response);
        this.results = sender.sentData();
        WikiPage errorLog = this.crawler.getPage(this.errorLogsParentPage, testPagePath);
        String errorLogContent = errorLog.getData().getContent();
        this.assertMessagesOccurInOrder(errorLogContent, new String[]{"Output of TestPage", "Output of TearDown", "Output of SuiteTearDown"});
        this.assertMessageHasJustOneOccurrenceOf(errorLogContent, "Output of TearDown");
    }

    @Test
    public void testSuiteSetUpAndSuiteTearDownWithSetUpAndTearDown() throws Exception {
        this.responder.setFastTest(false);
        WikiPage suitePage = this.crawler.addPage(this.root, PathParser.parse((String)"TestSuite"), this.classpathWidgets());
        WikiPage testPage = this.crawler.addPage(suitePage, PathParser.parse((String)"TestPage"), this.outputWritingTable("Output of TestPage"));
        this.crawler.addPage(suitePage, PathParser.parse((String)"SuiteSetUp"), this.outputWritingTable("Output of SuiteSetUp"));
        this.crawler.addPage(suitePage, PathParser.parse((String)"SetUp"), this.outputWritingTable("Output of SetUp"));
        this.crawler.addPage(suitePage, PathParser.parse((String)"SuiteTearDown"), this.outputWritingTable("Output of SuiteTearDown"));
        this.crawler.addPage(suitePage, PathParser.parse((String)"TearDown"), this.outputWritingTable("Output of TearDown"));
        WikiPagePath testPagePath = this.crawler.getFullPath(testPage);
        String resource = PathParser.render((WikiPagePath)testPagePath);
        this.request.setResource(resource);
        Response response = this.responder.makeResponse(this.context, (Request)this.request);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending(response);
        this.results = sender.sentData();
        WikiPage errorLog = this.crawler.getPage(this.errorLogsParentPage, testPagePath);
        String errorLogContent = errorLog.getData().getContent();
        this.assertMessagesOccurInOrder(errorLogContent, new String[]{"Output of SuiteSetUp", "Output of SetUp", "Output of TestPage", "Output of TearDown", "Output of SuiteTearDown"});
        this.assertMessageHasJustOneOccurrenceOf(errorLogContent, "Output of SetUp");
    }

    private void assertMessageHasJustOneOccurrenceOf(String output, String regexp) {
        Matcher match = Pattern.compile(regexp, 40).matcher(output);
        match.find();
        boolean found = match.find();
        if (found) {
            Assert.fail((String)("The regexp <" + regexp + "> was more than once in: " + output + "."));
        }
    }

    private void assertMessagesOccurInOrder(String errorLogContent, String ... messages) {
        int previousIndex = 0;
        int currentIndex = 0;
        String previousMsg = "";
        for (String msg : messages) {
            currentIndex = errorLogContent.indexOf(msg);
            Assert.assertTrue((String)String.format("\"%s\" should occur not before \"%s\", but did in \"%s\"", msg, previousMsg, errorLogContent), (currentIndex > previousIndex ? 1 : 0) != 0);
            previousIndex = currentIndex;
            previousMsg = msg;
        }
    }

    private String simpleSlimDecisionTable() {
        return "!define TEST_SYSTEM {slim}\n|!-DT:fitnesse.slim.test.TestSlim-!|\n|string|get string arg?|\n|wow|wow|\n";
    }

    @Test
    public void checkHistoryForSimpleSlimTable() throws Exception {
        this.ensureXmlResultFileDoesNotExist(new TestSummary(1, 0, 0, 0));
        this.doSimpleRun(this.simpleSlimDecisionTable());
        Document xmlFromFile = this.getXmlFromFileAndDeleteFile();
        this.xmlChecker.assertXmlHeaderIsCorrect(xmlFromFile);
        RegexTestCase.assertHasRegexp((String)"<td><span class=\"pass\">wow</span></td>", (String)Utils.unescapeHTML((String)this.results));
    }

    private String errorWritingTable(String message) {
        return "\n|!-fitnesse.testutil.ErrorWritingFixture-!|\n|" + message + "|\n\n";
    }

    private String outputWritingTable(String message) {
        return "\n|!-fitnesse.testutil.OutputWritingFixture-!|\n|" + message + "|\n\n";
    }

    private String classpathWidgets() {
        return "!path classes\n";
    }

    private String crashFixtureTable() {
        return "|!-fitnesse.testutil.CrashFixture-!|\n";
    }

    private String passFixtureTable() {
        return "|!-fitnesse.testutil.PassFixture-!|\n";
    }

    private String failFixtureTable() {
        return "|!-fitnesse.testutil.FailFixture-!|\n";
    }

    private String errorFixtureTable() {
        return "|!-fitnesse.testutil.ErrorFixture-!|\n";
    }

    static /* synthetic */ FitNesseContext access$000(TestResponderTest x0) {
        return x0.context;
    }

    static /* synthetic */ Response access$100(TestResponderTest x0) {
        return x0.response;
    }

    static /* synthetic */ String access$200(TestResponderTest x0) {
        return x0.results;
    }

    static /* synthetic */ XmlChecker access$300(TestResponderTest x0) {
        return x0.xmlChecker;
    }
}

