/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fit.Counts;
import fit.FitProtocol;
import fitnesse.FitNesseContext;
import fitnesse.http.MockRequest;
import fitnesse.http.MockResponseSender;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.responders.run.TestResultFormattingResponder;
import fitnesse.runner.HtmlResultFormatter;
import fitnesse.runner.MockResultFormatter;
import fitnesse.runner.PageResult;
import fitnesse.runner.XmlResultFormatter;
import fitnesse.testsystems.TestSummary;
import fitnesse.testutil.FitNesseUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestResultFormattingResponderTest
extends RegexTestCase {
    private PipedOutputStream output;
    private PipedInputStream input;
    private TestResultFormattingResponder responder;
    private MockResultFormatter formatter;
    private PageResult result1;
    private PageResult result2;
    private FitNesseContext context;

    public void setUp() throws Exception {
        this.output = new PipedOutputStream();
        this.input = new PipedInputStream(this.output);
        this.responder = new TestResultFormattingResponder();
        this.formatter = new MockResultFormatter();
        this.responder.formatter = this.formatter;
        this.result1 = new PageResult("Result1Title", new TestSummary(1, 2, 3, 4), "result1 data");
        this.result2 = new PageResult("Result2Title", new TestSummary(4, 3, 2, 1), "result2 data");
        this.context = FitNesseUtil.makeTestContext(null);
    }

    public void testOneResult() throws Exception {
        FitProtocol.writeData((String)this.result1.toString(), (OutputStream)this.output);
        FitProtocol.writeCounts((Counts)new Counts(0, 0, 0, 0), (OutputStream)this.output);
        this.responder.processResults((InputStream)this.input);
        TestResultFormattingResponderTest.assertEquals((int)1, (int)this.formatter.results.size());
        TestResultFormattingResponderTest.assertEquals((String)this.result1.toString(), (String)((PageResult)this.formatter.results.get(0)).toString());
    }

    public void testTwoResults() throws Exception {
        FitProtocol.writeData((String)this.result1.toString(), (OutputStream)this.output);
        FitProtocol.writeData((String)this.result2.toString(), (OutputStream)this.output);
        FitProtocol.writeCounts((Counts)new Counts(0, 0, 0, 0), (OutputStream)this.output);
        this.responder.processResults((InputStream)this.input);
        TestResultFormattingResponderTest.assertEquals((int)2, (int)this.formatter.results.size());
        TestResultFormattingResponderTest.assertEquals((String)this.result1.toString(), (String)((PageResult)this.formatter.results.get(0)).toString());
        TestResultFormattingResponderTest.assertEquals((String)this.result2.toString(), (String)((PageResult)this.formatter.results.get(1)).toString());
    }

    public void testFinalCounts() throws Exception {
        FitProtocol.writeData((String)this.result1.toString(), (OutputStream)this.output);
        Counts counts = new Counts(1, 2, 3, 4);
        FitProtocol.writeCounts((Counts)counts, (OutputStream)this.output);
        this.responder.processResults((InputStream)this.input);
        TestSummary summary = this.formatter.finalSummary;
        TestResultFormattingResponderTest.assertEquals((int)counts.right, (int)summary.getRight());
        TestResultFormattingResponderTest.assertEquals((int)counts.wrong, (int)summary.getWrong());
        TestResultFormattingResponderTest.assertEquals((int)counts.ignores, (int)summary.getIgnores());
        TestResultFormattingResponderTest.assertEquals((int)counts.exceptions, (int)summary.getExceptions());
    }

    public void testMakeResponse() throws Exception {
        MockRequest request = new MockRequest();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        FitProtocol.writeData((String)this.result1.toString(), (OutputStream)output);
        FitProtocol.writeData((String)this.result2.toString(), (OutputStream)output);
        FitProtocol.writeCounts((Counts)new Counts(5, 5, 5, 5), (OutputStream)output);
        request.addInput("results", (Object)output.toString());
        Response response = this.responder.makeResponse(this.context, (Request)request);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending(response);
        String html = sender.sentData();
        TestResultFormattingResponderTest.assertSubString((String)"Mock Results", (String)html);
    }

    public void testMockFormatter() throws Exception {
        this.checkFormatterCreated(null, MockResultFormatter.class);
    }

    public void testHtmlFormatter() throws Exception {
        this.checkFormatterCreated("html", HtmlResultFormatter.class);
    }

    public void testXmlFormatter() throws Exception {
        this.checkFormatterCreated("xml", XmlResultFormatter.class);
    }

    private void checkFormatterCreated(String format, Class<?> formatterClass) throws Exception {
        MockRequest request = new MockRequest();
        request.addHeader("Host", (Object)"locahost:8080");
        request.setResource("/");
        if (format != null) {
            request.addInput("format", (Object)format);
        }
        this.responder.init(this.context, (Request)request);
        TestResultFormattingResponderTest.assertEquals(formatterClass, this.responder.formatter.getClass());
    }
}

