/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.FitNesseVersion;
import fitnesse.responders.run.SuiteExecutionReport;
import fitnesse.responders.run.formatters.BaseFormatter;
import fitnesse.testsystems.CompositeExecutionLog;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.IOException;
import java.util.List;
import util.TimeMeasurement;

public class SuiteExecutionReportFormatter
extends BaseFormatter {
    private SuiteExecutionReport.PageHistoryReference referenceToCurrentTest;
    protected SuiteExecutionReport suiteExecutionReport = new SuiteExecutionReport();

    public SuiteExecutionReportFormatter(FitNesseContext context, WikiPage page) {
        super(context, page);
        this.suiteExecutionReport.version = new FitNesseVersion().toString();
        this.suiteExecutionReport.rootPath = this.page.getName();
    }

    public void setExecutionLogAndTrackingId(String stopResponderId, CompositeExecutionLog log) {
    }

    public void testSystemStarted(TestSystem testSystem, String testSystemName, String testRunner) {
    }

    public void newTestStarted(TestPage test, TimeMeasurement timeMeasurement) {
        String pageName = PathParser.render((WikiPagePath)test.getSourcePage().getPageCrawler().getFullPath(test.getSourcePage()));
        this.referenceToCurrentTest = new SuiteExecutionReport.PageHistoryReference(pageName, timeMeasurement.startedAt(), timeMeasurement.elapsed());
    }

    public void testOutputChunk(String output) {
    }

    public String getRootPageName() {
        return this.suiteExecutionReport.getRootPath();
    }

    public String getFitNesseVersion() {
        return new FitNesseVersion().toString();
    }

    public void testComplete(TestPage test, TestSummary testSummary, TimeMeasurement timeMeasurement) {
        this.referenceToCurrentTest.setTestSummary(testSummary);
        this.referenceToCurrentTest.setRunTimeInMillis(timeMeasurement.elapsed());
        this.suiteExecutionReport.addPageHistoryReference(this.referenceToCurrentTest);
        this.suiteExecutionReport.tallyPageCounts(ExecutionResult.getExecutionResult((String)test.getName(), (TestSummary)testSummary));
        this.failCount += testSummary.wrong;
        this.failCount += testSummary.exceptions;
    }

    public List<SuiteExecutionReport.PageHistoryReference> getPageHistoryReferences() {
        return this.suiteExecutionReport.getPageHistoryReferences();
    }

    public int getErrorCount() {
        return this.getPageCounts().wrong + this.getPageCounts().exceptions;
    }

    public void allTestingComplete(TimeMeasurement totalTimeMeasurement) throws IOException {
        super.allTestingComplete(totalTimeMeasurement);
        this.suiteExecutionReport.setTotalRunTimeInMillis(totalTimeMeasurement);
    }

    public TestSummary getPageCounts() {
        return this.suiteExecutionReport.getFinalCounts();
    }
}

