/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.search;

import fitnesse.FitNesseContext;
import fitnesse.http.MockRequest;
import fitnesse.http.MockResponseSender;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.responders.search.SearchResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class SearchResponderTest
extends RegexTestCase {
    private WikiPage root;
    private PageCrawler crawler;
    private SearchResponder responder;
    private MockRequest request;
    private FitNesseContext context;

    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        this.crawler.addPage(this.root, PathParser.parse((String)"SomePage"), "has something in it");
        this.request = new MockRequest();
        this.request.addInput("searchString", (Object)"blah");
        this.request.addInput("searchType", (Object)"blah");
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.responder = new SearchResponder();
    }

    public void tearDown() throws Exception {
    }

    public void testHtml() throws Exception {
        String content = this.getResponseContentUsingSearchString("something");
        SearchResponderTest.assertHasRegexp((String)"something", (String)content);
        SearchResponderTest.assertHasRegexp((String)"SomePage", (String)content);
    }

    public void testTableSorterScript() throws Exception {
        String content = this.getResponseContentUsingSearchString("something");
        SearchResponderTest.assertSubString((String)"tableSorter = new TableSorter('searchResultsTable'", (String)content);
    }

    public void testClientSideSortScript() throws Exception {
        String content = this.getResponseContentUsingSearchString("something");
        SearchResponderTest.assertHasRegexp((String)"<script src=\"/files/fitnesse/javascript/clientSideSort.js\"> </script>", (String)content);
    }

    public void testPageSortLink() throws Exception {
        String content = this.getResponseContentUsingSearchString("something");
        SearchResponderTest.assertSubString((String)"<a href=\"javascript:void(tableSorter.sort(1));\">Page</a>", (String)content);
    }

    public void testLastModifiedSortLink() throws Exception {
        String content = this.getResponseContentUsingSearchString("something");
        SearchResponderTest.assertSubString((String)"<a href=\"javascript:void(tableSorter.sort(3, 'date'));\">LastModified</a>", (String)content);
    }

    public void testNoSearchStringBringsUpNoResults() throws Exception {
        String content = this.getResponseContentUsingSearchString("");
        SearchResponderTest.assertSubString((String)"No pages matched your search criteria.", (String)content);
    }

    public void testEscapesSearchString() throws Exception {
        String content = this.getResponseContentUsingSearchString("!+-<&>");
        SearchResponderTest.assertSubString((String)"!+-<&>", (String)content);
    }

    private String getResponseContentUsingSearchString(String searchString) throws Exception {
        this.request.addInput("searchString", (Object)searchString);
        Response response = this.responder.makeResponse(this.context, (Request)this.request);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending(response);
        return sender.sentData();
    }

    public void testTitle() throws Exception {
        this.request.addInput("searchType", (Object)"something with the word title in it");
        this.responder.setRequest((Request)this.request);
        String title = this.responder.getTitle();
        SearchResponderTest.assertSubString((String)"Title Search Results", (String)title);
        this.request.addInput("searchType", (Object)"something with the word content in it");
        title = this.responder.getTitle();
        SearchResponderTest.assertSubString((String)"Content Search Results", (String)title);
    }
}

