/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.templateUtilities;

import fitnesse.FitNesseContext;
import fitnesse.responders.templateUtilities.HtmlPage;
import fitnesse.responders.templateUtilities.PageTitle;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.PathParser;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class HtmlPageTest
extends RegexTestCase {
    private HtmlPage page;
    private String html;
    private FitNesseContext context;

    public void setUp() throws Exception {
        this.context = FitNesseUtil.makeTestContext(null);
        this.page = new HtmlPage(this.context.pageFactory.getVelocityEngine(), "skeleton.vm", "fitnesse_theme");
        this.html = this.page.html();
    }

    public void tearDown() throws Exception {
    }

    public void testStandardTags() throws Exception {
        HtmlPageTest.assertTrue((String)("bad doctype for page: " + this.html), (boolean)this.html.startsWith("<!DOCTYPE html>"));
        HtmlPageTest.assertSubString((String)"<html>", (String)this.html);
        HtmlPageTest.assertHasRegexp((String)"</html>", (String)this.html);
    }

    public void testHead() throws Exception {
        HtmlPageTest.assertSubString((String)"<head>", (String)this.html);
        HtmlPageTest.assertSubString((String)"</head>", (String)this.html);
        HtmlPageTest.assertSubString((String)"<title>FitNesse</title>", (String)this.html);
        HtmlPageTest.assertSubString((String)"<link", (String)this.html);
        HtmlPageTest.assertSubString((String)"rel=\"stylesheet\"", (String)this.html);
        HtmlPageTest.assertSubString((String)"type=\"text/css\"", (String)this.html);
        HtmlPageTest.assertSubString((String)"href=\"/files/fitnesse/css/fitnesse_theme.css\"", (String)this.html);
        HtmlPageTest.assertSubString((String)"src=\"/files/fitnesse/javascript/fitnesse.js\"", (String)this.html);
        HtmlPageTest.assertSubString((String)"src=\"/files/fitnesse/javascript/fitnesse_theme.js\"", (String)this.html);
    }

    public void testIncludesBody() throws Exception {
        HtmlPageTest.assertSubString((String)"<body>", (String)this.html);
        HtmlPageTest.assertSubString((String)"</body>", (String)this.html);
    }

    public void testIncludesHeading() throws Exception {
        HtmlPageTest.assertSubString((String)"<header>", (String)this.html);
    }

    public void testMainBar() throws Exception {
        HtmlPageTest.assertSubString((String)"<article>", (String)this.html);
        String mainHtml = this.page.html();
        HtmlPageTest.assertSubString((String)"<header>", (String)mainHtml);
        HtmlPageTest.assertSubString((String)"<article>", (String)mainHtml);
    }

    public void testSidebar() throws Exception {
        HtmlPageTest.assertSubString((String)"<nav>", (String)this.html);
    }

    public void testBreadCrumbsWithCurrentPageLinked() throws Exception {
        String trail = "TstPg1.TstPg2.TstPg3.TstPg4";
        this.page.setPageTitle(new PageTitle(PathParser.parse((String)trail)));
        String breadcrumbs = this.page.html();
        HtmlPageTest.assertSubString((String)"<a href=\"/TstPg1\">TstPg1</a>", (String)breadcrumbs);
        HtmlPageTest.assertSubString((String)"<a href=\"/TstPg1.TstPg2\">TstPg2</a>", (String)breadcrumbs);
        HtmlPageTest.assertSubString((String)"<a href=\"/TstPg1.TstPg2.TstPg3\">TstPg3</a>", (String)breadcrumbs);
        HtmlPageTest.assertSubString((String)"<a href=\"/TstPg1.TstPg2.TstPg3.TstPg4\">TstPg4</a>", (String)breadcrumbs);
    }

    public void testBreadCrumbsWithCurrentPageNotLinked() throws Exception {
        String trail = "TstPg1.TstPg2.TstPg3.TstPg4";
        this.page.setPageTitle(new PageTitle(PathParser.parse((String)trail)).notLinked());
        String breadcrumbs = this.page.html();
        HtmlPageTest.assertSubString((String)"<a href=\"/TstPg1\">TstPg1</a>", (String)breadcrumbs);
        HtmlPageTest.assertSubString((String)"<a href=\"/TstPg1.TstPg2\">TstPg2</a>", (String)breadcrumbs);
        HtmlPageTest.assertSubString((String)"<a href=\"/TstPg1.TstPg2.TstPg3\">TstPg3</a>", (String)breadcrumbs);
        HtmlPageTest.assertHasRegexp((String)"<h1>\\s*TstPg4\\s*</h1>", (String)breadcrumbs);
    }

    public void testBreadCrumbsWithPageType() throws Exception {
        String trail = "TstPg1.TstPg2.TstPg3.TstPg4";
        this.page.setPageTitle(new PageTitle("Some Type", PathParser.parse((String)trail)));
        String breadcrumbs = this.page.html();
        HtmlPageTest.assertSubString((String)"<a href=\"/TstPg1.TstPg2.TstPg3.TstPg4\">TstPg4</a>", (String)breadcrumbs);
    }
}

