/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.templateUtilities;

import fitnesse.responders.templateUtilities.PageTitle;
import fitnesse.wiki.PathParser;
import org.junit.Assert;
import org.junit.Test;

public class PageTitleTest {
    @Test
    public void defaultPageTitleHasNoTitleLinkOrBreadCrumbs() throws Exception {
        PageTitle pt = new PageTitle();
        Assert.assertNull((Object)pt.getTitle());
        Assert.assertNull((Object)pt.getLink());
        Assert.assertNull((Object)pt.getPageType());
        Assert.assertNull((Object)pt.getPageTags());
        Assert.assertEquals((long)0L, (long)pt.getBreadCrumbs().size());
    }

    @Test
    public void pageTitleWithTypeButNoResourceHasTypeAndTitleButNoLinkOrBreadCrumbs() throws Exception {
        PageTitle pt = new PageTitle("Title");
        Assert.assertEquals((Object)"Title", (Object)pt.getTitle());
        Assert.assertNull((Object)pt.getLink());
        Assert.assertEquals((Object)"Title", (Object)pt.getPageType());
        Assert.assertEquals((long)0L, (long)pt.getBreadCrumbs().size());
    }

    @Test
    public void oneElementPageNameHasLinkAndTitleButNoBreadCrumbs() throws Exception {
        PageTitle pt = new PageTitle(PathParser.parse((String)"SimplePage"));
        Assert.assertEquals((Object)"SimplePage", (Object)pt.getTitle());
        Assert.assertEquals((Object)"SimplePage", (Object)pt.getLink());
        Assert.assertEquals((long)0L, (long)pt.getBreadCrumbs().size());
        Assert.assertNull((Object)pt.getPageType());
    }

    @Test
    public void twoElementPageNameHasLinkTitleAndBreadCrumb() throws Exception {
        PageTitle pt = new PageTitle(PathParser.parse((String)"ParentPage.ChildPage"));
        Assert.assertEquals((Object)"ChildPage", (Object)pt.getTitle());
        Assert.assertEquals((Object)"ParentPage.ChildPage", (Object)pt.getLink());
        Assert.assertEquals((long)1L, (long)pt.getBreadCrumbs().size());
        PageTitle.BreadCrumb crumb = (PageTitle.BreadCrumb)pt.getBreadCrumbs().get(0);
        Assert.assertEquals((Object)"ParentPage", (Object)crumb.getName());
        Assert.assertEquals((Object)"ParentPage", (Object)crumb.getLink());
    }

    @Test
    public void threeElementPagenameHasLinkTitleAndBreadCrumbs() throws Exception {
        PageTitle pt = new PageTitle(PathParser.parse((String)"ParentPage.ChildPage.GrandChildPage"));
        Assert.assertEquals((Object)"GrandChildPage", (Object)pt.getTitle());
        Assert.assertEquals((Object)"ParentPage.ChildPage.GrandChildPage", (Object)pt.getLink());
        Assert.assertEquals((long)2L, (long)pt.getBreadCrumbs().size());
        PageTitle.BreadCrumb crumb = (PageTitle.BreadCrumb)pt.getBreadCrumbs().get(0);
        Assert.assertEquals((Object)"ParentPage", (Object)crumb.getName());
        Assert.assertEquals((Object)"ParentPage", (Object)crumb.getLink());
        crumb = (PageTitle.BreadCrumb)pt.getBreadCrumbs().get(1);
        Assert.assertEquals((Object)"ChildPage", (Object)crumb.getName());
        Assert.assertEquals((Object)"ParentPage.ChildPage", (Object)crumb.getLink());
    }

    @Test
    public void pageTitleWithPathAndTypeHasAllElements() throws Exception {
        PageTitle pt = new PageTitle("type", PathParser.parse((String)"ParentPage.ChildPage"));
        Assert.assertEquals((Object)"ChildPage", (Object)pt.getTitle());
        Assert.assertEquals((Object)"ParentPage.ChildPage", (Object)pt.getLink());
        Assert.assertEquals((long)1L, (long)pt.getBreadCrumbs().size());
        PageTitle.BreadCrumb crumb = (PageTitle.BreadCrumb)pt.getBreadCrumbs().get(0);
        Assert.assertEquals((Object)"ParentPage", (Object)crumb.getName());
        Assert.assertEquals((Object)"ParentPage", (Object)crumb.getLink());
        Assert.assertEquals((Object)"type", (Object)pt.getPageType());
    }

    @Test
    public void pageTitleWithPathAndTypeHasAllElementsAndTags() throws Exception {
        PageTitle pt = new PageTitle("type", PathParser.parse((String)"ParentPage.ChildPage"), "page tags");
        Assert.assertEquals((Object)"ChildPage", (Object)pt.getTitle());
        Assert.assertEquals((Object)"ParentPage.ChildPage", (Object)pt.getLink());
        Assert.assertEquals((long)1L, (long)pt.getBreadCrumbs().size());
        PageTitle.BreadCrumb crumb = (PageTitle.BreadCrumb)pt.getBreadCrumbs().get(0);
        Assert.assertEquals((Object)"ParentPage", (Object)crumb.getName());
        Assert.assertEquals((Object)"ParentPage", (Object)crumb.getLink());
        Assert.assertEquals((Object)"type", (Object)pt.getPageType());
        Assert.assertEquals((Object)"page tags", (Object)pt.getPageTags());
    }

    @Test
    public void pageTitleWithFileSeparator() {
        PageTitle pt = new PageTitle("type", "files/templates/main.html", "/");
        Assert.assertEquals((Object)"main.html", (Object)pt.getTitle());
        Assert.assertEquals((Object)"files/templates/main.html", (Object)pt.getLink());
        Assert.assertEquals((long)2L, (long)pt.getBreadCrumbs().size());
        PageTitle.BreadCrumb crumb = (PageTitle.BreadCrumb)pt.getBreadCrumbs().get(0);
        Assert.assertEquals((Object)"files", (Object)crumb.getName());
        Assert.assertEquals((Object)"files", (Object)crumb.getLink());
        crumb = (PageTitle.BreadCrumb)pt.getBreadCrumbs().get(1);
        Assert.assertEquals((Object)"templates", (Object)crumb.getName());
        Assert.assertEquals((Object)"files/templates", (Object)crumb.getLink());
        Assert.assertEquals((Object)"type", (Object)pt.getPageType());
    }

    @Test
    public void pageTitleWithFileSeparatorAndTags() {
        PageTitle pt = new PageTitle("type", "files/templates/main.html", "/", "page tags");
        Assert.assertEquals((Object)"main.html", (Object)pt.getTitle());
        Assert.assertEquals((Object)"files/templates/main.html", (Object)pt.getLink());
        Assert.assertEquals((long)2L, (long)pt.getBreadCrumbs().size());
        PageTitle.BreadCrumb crumb = (PageTitle.BreadCrumb)pt.getBreadCrumbs().get(0);
        Assert.assertEquals((Object)"files", (Object)crumb.getName());
        Assert.assertEquals((Object)"files", (Object)crumb.getLink());
        crumb = (PageTitle.BreadCrumb)pt.getBreadCrumbs().get(1);
        Assert.assertEquals((Object)"templates", (Object)crumb.getName());
        Assert.assertEquals((Object)"files/templates", (Object)crumb.getLink());
        Assert.assertEquals((Object)"type", (Object)pt.getPageType());
        Assert.assertEquals((Object)"page tags", (Object)pt.getPageTags());
    }
}

