/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.SlimException;
import fitnesse.slim.StatementExecutorInterface;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class SlimInstanceCreationTestBase {
    protected StatementExecutorInterface caller;
    protected String testClass = "TestSlim";

    @Before
    public abstract void setUp() throws Exception;

    protected abstract void assertInstanceOfTestSlim(Object var1);

    protected abstract String getTestClassPath();

    protected String getTestClassName() {
        return this.getTestClassPath() + "." + this.testClass;
    }

    @Test
    public void canCreateInstance() throws Exception {
        this.caller.create("x", this.getTestClassName(), new Object[0]);
        Object x = this.caller.getInstance("x");
        this.assertInstanceOfTestSlim(x);
    }

    @Test
    public void canCreateInstanceWhenSpecifiedBySymbol() throws Exception {
        this.caller.setVariable("X", (Object)this.getTestClassName());
        this.caller.create("x", "$X", new Object[0]);
        Object x = this.caller.getInstance("x");
        this.assertInstanceOfTestSlim(x);
    }

    @Test
    public void canSetActorFromInstanceStoredInSymbol() throws Exception {
        this.caller.create("x", this.getTestClassName(), new Object[0]);
        Object x = this.caller.getInstance("x");
        this.caller.setVariable("X", x);
        this.caller.create("y", "$X", new Object[0]);
        Object y = this.caller.getInstance("y");
        Assert.assertEquals((Object)x, (Object)y);
    }

    @Test
    public void canCreateInstanceWithArguments() throws Exception {
        this.caller.create("x", this.getTestClassName(), new Object[]{"3"});
        Object x = this.caller.getInstance("x");
        this.assertInstanceOfTestSlim(x);
    }

    @Test(expected=SlimException.class)
    public void cantCreateInstanceIfConstructorArgumentBad() throws Exception {
        this.caller.create("x", this.getTestClassName(), new Object[]{"notInt"});
    }

    @Test(expected=SlimException.class)
    public void cantCreateInstanceIfConstructorArgumentCountIncorrect() throws Exception {
        this.caller.create("x", this.getTestClassName(), new Object[]{"3", "4"});
    }

    @Test(expected=SlimException.class)
    public void throwsInstanceNotCreatedErrorIfNoSuchClass() throws Exception {
        this.caller.create("x", this.getTestClassPath() + ".NoSuchClass", new Object[0]);
    }

    @Test(expected=SlimException.class)
    public void throwsInstanceNotCreatedErrorIfNoPublicDefaultConstructor() throws Exception {
        this.caller.create("x", this.getTestClassPath() + ".ClassWithNoPublicDefaultConstructor", new Object[0]);
    }

    @Test
    public void canAddPath() throws Exception {
        this.caller.addPath(this.getTestClassPath());
        this.caller.create("x", this.testClass, new Object[0]);
        Object x = this.caller.getInstance("x");
        this.assertInstanceOfTestSlim(x);
    }

    @Test(expected=SlimException.class)
    public void cantCreateInstanceWithoutPath() throws Exception {
        this.caller.create("x", this.testClass, new Object[0]);
    }
}

