/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems;

import fitnesse.testsystems.CommandRunner;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.TimeMeasurement;

public class CommandRunner {
    private Process process;
    private String input = "";
    protected List<Throwable> exceptions = new ArrayList();
    private OutputStream stdin;
    private InputStream stdout;
    private InputStream stderr;
    protected StringBuffer outputBuffer = new StringBuffer();
    protected StringBuffer errorBuffer = new StringBuffer();
    protected int exitCode = -1;
    private TimeMeasurement timeMeasurement = new TimeMeasurement();
    private String command = "";
    private Map<String, String> environmentVariables;

    public CommandRunner() {
    }

    public CommandRunner(String command, String input) {
        this(command, input, null);
    }

    public CommandRunner(String command, String input, Map<String, String> environmentVariables) {
        this.command = command;
        this.input = input;
        this.environmentVariables = environmentVariables;
    }

    protected CommandRunner(String command, String input, int exitCode) {
        this(command, input);
        this.exitCode = exitCode;
    }

    public void asynchronousStart() throws IOException {
        Runtime rt = Runtime.getRuntime();
        this.timeMeasurement.start();
        String[] environmentVariables = this.determineEnvironment();
        this.process = rt.exec(this.command, environmentVariables);
        this.stdin = this.process.getOutputStream();
        this.stdout = this.process.getInputStream();
        this.stderr = this.process.getErrorStream();
        new Thread((Runnable)new OutputReadingRunnable(this, this.stdout, this.outputBuffer), "CommandRunner stdout").start();
        new Thread((Runnable)new OutputReadingRunnable(this, this.stderr, this.errorBuffer), "CommandRunner error").start();
        this.sendInput();
    }

    private String[] determineEnvironment() {
        if (this.environmentVariables == null) {
            return null;
        }
        HashMap<String, String> systemVariables = new HashMap<String, String>(System.getenv());
        systemVariables.putAll(this.environmentVariables);
        ArrayList<String> systemVariableAssignments = new ArrayList<String>();
        for (Map.Entry entry : systemVariables.entrySet()) {
            systemVariableAssignments.add((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        return systemVariableAssignments.toArray(new String[systemVariableAssignments.size()]);
    }

    public void run() throws Exception {
        this.asynchronousStart();
        this.join();
    }

    public void join() {
        this.waitForDeathOf(this.process);
        this.timeMeasurement.stop();
        this.exitCode = this.process.exitValue();
    }

    private void waitForDeathOf(Process process) {
        int timeStep = 100;
        try {
            for (int maxDelay = 2000; maxDelay > 0; maxDelay -= timeStep) {
                if (this.isDead(process)) {
                    return;
                }
                Thread.sleep(timeStep);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.err.println("Could not detect death of command line test runner.");
    }

    private boolean isDead(Process process) throws InterruptedException {
        try {
            process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    public void kill() {
        if (this.process != null) {
            this.process.destroy();
            this.join();
        }
    }

    protected void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public String getOutput() {
        return this.outputBuffer.toString();
    }

    public String getError() {
        return this.errorBuffer.toString();
    }

    public List<Throwable> getExceptions() {
        return this.exceptions;
    }

    public boolean hasExceptions() {
        return this.exceptions.size() > 0;
    }

    public boolean wroteToErrorStream() {
        return this.errorBuffer.length() > 0;
    }

    public boolean wroteToOutputStream() {
        return this.outputBuffer.length() > 0;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void exceptionOccurred(Exception e) {
        this.exceptions.add(e);
    }

    public long getExecutionTime() {
        return this.timeMeasurement.elapsed();
    }

    protected void sendInput() {
        1 thread = new /* Unavailable Anonymous Inner Class!! */;
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public int waitForCommandToFinish() throws InterruptedException {
        return this.process.waitFor();
    }

    static /* synthetic */ String access$000(CommandRunner x0) {
        return x0.input;
    }

    static /* synthetic */ OutputStream access$100(CommandRunner x0) {
        return x0.stdin;
    }
}

