/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems;

import fitnesse.responders.run.SuiteContentsFinder;
import fitnesse.testsystems.PageListSetUpTearDownSurrounder;
import fitnesse.testsystems.TestPage;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PageListSetUpTearDownSurrounderTest {
    private WikiPage root;
    private WikiPage suite;
    private WikiPage testPage;
    private PageCrawler crawler;
    private PageListSetUpTearDownSurrounder surrounder;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        PageData data = this.root.getData();
        this.root.commit(data);
        this.suite = this.crawler.addPage(this.root, PathParser.parse((String)"SuitePageName"), "The is the test suite\n");
        this.testPage = this.crawler.addPage(this.suite, PathParser.parse((String)"TestPage"), "My test and has some content");
        this.surrounder = new PageListSetUpTearDownSurrounder(this.root);
    }

    @Test
    public void testPagesForTestSystemAreSurroundedByRespectiveSuiteSetupAndTeardown() throws Exception {
        WikiPage slimPage = this.crawler.addPage(this.testPage, PathParser.parse((String)"SlimPageTest"));
        WikiPage setUp = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteSetUp"));
        WikiPage tearDown = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteTearDown"));
        WikiPage setUp2 = this.crawler.addPage(slimPage, PathParser.parse((String)"SuiteSetUp"));
        WikiPage tearDown2 = this.crawler.addPage(slimPage, PathParser.parse((String)"SuiteTearDown"));
        ArrayList testPages = this.MakeTestPageList();
        this.surrounder.surroundGroupsOfTestPagesWithRespectiveSetUpAndTearDowns((List)testPages);
        Assert.assertEquals((long)6L, (long)testPages.size());
        Assert.assertSame((Object)setUp2, (Object)((TestPage)testPages.get(0)).getSourcePage());
        Assert.assertSame((Object)slimPage, (Object)((TestPage)testPages.get(1)).getSourcePage());
        Assert.assertSame((Object)tearDown2, (Object)((TestPage)testPages.get(2)).getSourcePage());
        Assert.assertSame((Object)setUp, (Object)((TestPage)testPages.get(3)).getSourcePage());
        Assert.assertSame((Object)this.testPage, (Object)((TestPage)testPages.get(4)).getSourcePage());
        Assert.assertSame((Object)tearDown, (Object)((TestPage)testPages.get(5)).getSourcePage());
    }

    private ArrayList<TestPage> MakeTestPageList() throws Exception {
        SuiteContentsFinder finder = new SuiteContentsFinder(this.suite, null, this.root);
        ArrayList<TestPage> testPages = new ArrayList<TestPage>();
        for (WikiPage page : finder.getAllPagesToRunForThisSuite()) {
            testPages.add(new TestPage(page));
        }
        return testPages;
    }

    @Test
    public void testSetUpAndTearDown() throws Exception {
        WikiPage setUp = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteSetUp"), "suite set up");
        WikiPage tearDown = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteTearDown"), "suite tear down");
        ArrayList testPages = this.MakeTestPageList();
        this.surrounder.surroundGroupsOfTestPagesWithRespectiveSetUpAndTearDowns((List)testPages);
        Assert.assertEquals((long)3L, (long)testPages.size());
        Assert.assertSame((Object)setUp, (Object)((TestPage)testPages.get(0)).getSourcePage());
        Assert.assertSame((Object)this.testPage, (Object)((TestPage)testPages.get(1)).getSourcePage());
        Assert.assertSame((Object)tearDown, (Object)((TestPage)testPages.get(2)).getSourcePage());
    }
}

