/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems;

import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestPageWithSuiteSetUpAndTearDown;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import org.junit.Before;
import org.junit.Test;
import util.RegexTestCase;

public class TestPageTest {
    private PageCrawler crawler;
    private WikiPage root;
    private WikiPage wikiPage;
    private WikiPage subPage;
    private WikiPage subTestPage;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        this.wikiPage = this.addPage("TestPage", "!define TEST_SYSTEM {slim}\nthe content");
        this.addPage("SetUp", "setup");
        this.addPage("TearDown", "teardown");
        this.addPage("SuiteSetUp", "suiteSetUp");
        this.addPage("SuiteTearDown", "suiteTearDown");
        this.subPage = this.crawler.addPage(this.wikiPage, PathParser.parse((String)"SubPage"), "sub page");
        this.crawler.addPage(this.wikiPage, PathParser.parse((String)"ScenarioLibrary"), "scenario library 2");
        this.subTestPage = this.crawler.addPage(this.subPage, PathParser.parse((String)"TestSubPage"), "sub test page");
        this.crawler.addPage(this.subPage, PathParser.parse((String)"ScenarioLibrary"), "scenario library 3");
    }

    private WikiPage addPage(String pageName, String content) throws Exception {
        return this.crawler.addPage(this.root, PathParser.parse((String)pageName), content);
    }

    @Test
    public void testIncludeSetupTearDownOutsideOfSuite() throws Exception {
        TestPage testPage = new TestPage(this.wikiPage);
        String html = testPage.getDecoratedData().getHtml();
        RegexTestCase.assertSubString((String)".SetUp", (String)html);
        RegexTestCase.assertSubString((String)"setup", (String)html);
        RegexTestCase.assertSubString((String)".TearDown", (String)html);
        RegexTestCase.assertSubString((String)"teardown", (String)html);
        RegexTestCase.assertSubString((String)"the content", (String)html);
        RegexTestCase.assertSubString((String)"class=\"collapsible closed\"", (String)html);
        RegexTestCase.assertNotSubString((String)".SuiteSetUp", (String)html);
        RegexTestCase.assertNotSubString((String)"suiteSetUp", (String)html);
        RegexTestCase.assertNotSubString((String)".SuiteTearDown", (String)html);
        RegexTestCase.assertNotSubString((String)"suitTearDown", (String)html);
    }

    @Test
    public void testIncludeSetupTearDownInsideOfSuite() throws Exception {
        TestPageWithSuiteSetUpAndTearDown test = new TestPageWithSuiteSetUpAndTearDown(this.wikiPage);
        String html = test.getDecoratedData().getHtml();
        RegexTestCase.assertSubString((String)".SetUp", (String)html);
        RegexTestCase.assertSubString((String)"setup", (String)html);
        RegexTestCase.assertSubString((String)".TearDown", (String)html);
        RegexTestCase.assertSubString((String)"teardown", (String)html);
        RegexTestCase.assertSubString((String)"the content", (String)html);
        RegexTestCase.assertSubString((String)"class=\"collapsible closed\"", (String)html);
        RegexTestCase.assertSubString((String)".SuiteSetUp", (String)html);
        RegexTestCase.assertSubString((String)"suiteSetUp", (String)html);
        RegexTestCase.assertSubString((String)".SuiteTearDown", (String)html);
        RegexTestCase.assertSubString((String)"suiteTearDown", (String)html);
        RegexTestCase.assertEquals((String)"SetUp occurs more than once", (int)html.indexOf(" SetUp"), (int)html.lastIndexOf(" SetUp"));
        RegexTestCase.assertEquals((String)"TearDown occurs more than once", (int)html.indexOf(" TearDown"), (int)html.lastIndexOf(" TearDown"));
    }

    @Test
    public void includeScenarioLibraryBrother() throws Exception {
        WikiPage slimTestPage = this.addPage("SlimTest", "!define TEST_SYSTEM {slim}\n");
        TestPage testPage = new TestPage(slimTestPage);
        this.addPage("ScenarioLibrary", "scenario library");
        String html = testPage.getDecoratedData().getHtml();
        RegexTestCase.assertSubString((String)"scenario library", (String)html);
    }

    @Test
    public void includeScenarioLibraryUnclesInOrder() throws Exception {
        this.addPage("TestPage.TestPageChild", "child");
        this.addPage("TestPage.ScenarioLibrary", "child library");
        WikiPage nephew = this.addPage("TestPage.TestPageChild.TestPageGrandChild", "!define TEST_SYSTEM {slim}\n");
        this.addPage("TestPage.TestPageChild.ScenarioLibrary", "grand child library");
        TestPage testPage = new TestPage(nephew);
        String html = testPage.getDecoratedData().getHtml();
        RegexTestCase.assertSubString((String)"child library", (String)html);
        RegexTestCase.assertSubString((String)"grand child library", (String)html);
        RegexTestCase.assertSubString((String)"TestPage.ScenarioLibrary", (String)html);
        RegexTestCase.assertSubString((String)"TestPage.TestPageChild.ScenarioLibrary", (String)html);
        RegexTestCase.assertSubString((String)"Scenario Libraries", (String)html);
        RegexTestCase.assertTrue((html.indexOf("grand child library") > html.indexOf("child library") ? 1 : 0) != 0);
    }

    @Test
    public void shouldNotContainScenarioLibrarySectionIfThereAreNone() throws Exception {
        WikiPage slimTestPage = this.addPage("SlimTest", "!define TEST_SYSTEM {slim}\n");
        TestPage testPage = new TestPage(slimTestPage);
        String html = testPage.getDecoratedData().getHtml();
        RegexTestCase.assertNotSubString((String)"Scenario Libraries", (String)html);
    }

    @Test
    public void shouldNotIncludeScenarioLibrariesIfNotSlimTest() throws Exception {
        this.addPage("ScenarioLibrary", "scenario library");
        WikiPage someTest = this.addPage("SomeTest", "some test");
        TestPage testPage = new TestPage(someTest);
        String html = testPage.getDecoratedData().getHtml();
        RegexTestCase.assertNotSubString((String)"scenario library", (String)html);
    }
}

