/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.instructions.Instruction;
import fitnesse.testsystems.slim.HtmlTableScanner;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.SlimTestContextImpl;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;

public abstract class SlimTableTestSupport<T extends SlimTable> {
    private WikiPage root;
    protected List<Instruction> instructions;
    protected T tableUnderTest;

    private Class<T> getParameterizedClass() {
        Type superclass = this.getClass().getGenericSuperclass();
        if (superclass instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)ParameterizedType.class.cast(superclass);
            return (Class)type.getActualTypeArguments()[0];
        }
        throw new IllegalStateException("Unable to detect the actual type of SlimTable.");
    }

    public T createSlimTable(String tableText) {
        try {
            Constructor constructor = this.getParameterizedClass().getConstructor(Table.class, String.class, SlimTestContext.class);
            WikiPageUtil.setPageContents((WikiPage)this.root, (String)tableText);
            String html = this.root.getData().getHtml();
            HtmlTableScanner ts = new HtmlTableScanner(html);
            Table t = ts.getTable(0);
            SlimTestContextImpl testContext = new SlimTestContextImpl();
            return (T)((SlimTable)constructor.newInstance(t, "id", testContext));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"root");
        this.instructions = new ArrayList();
    }

    protected T makeSlimTableAndBuildInstructions(String pageContents) throws Exception {
        this.tableUnderTest = this.createSlimTable(pageContents);
        this.instructions.addAll(Assertion.getInstructions((List)this.tableUnderTest.getAssertions()));
        return (T)this.tableUnderTest;
    }
}

