/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.updates;

import fitnesse.updates.ReplacingFileUpdate;
import fitnesse.updates.Update;
import fitnesse.updates.UpdateTestCase;
import java.io.File;
import java.io.FileOutputStream;
import org.junit.Assert;
import org.junit.Test;
import util.FileUtil;

public class ReplacingFileUpdateTest
extends UpdateTestCase {
    public final String sourceFilename = "classes/testFile";
    public final File sourceFile = new File("classes/testFile");
    public final String destDirName = "subDir";
    public final String destPath = "TestDir/subDir/testFile";
    public final File destFile = new File("TestDir/subDir/testFile");

    public void setUp() throws Exception {
        super.setUp();
        this.sourceFile.createNewFile();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.sourceFile.delete();
    }

    protected Update makeUpdate() throws Exception {
        return new ReplacingFileUpdate(this.context.getRootPagePath(), "testFile", "subDir");
    }

    @Test
    public void testNoDestination() throws Exception {
        Assert.assertTrue((boolean)this.update.shouldBeApplied());
        this.update.doUpdate();
        Assert.assertTrue((boolean)this.destFile.exists());
    }

    @Test
    public void testFileMatch() throws Exception {
        this.update.doUpdate();
        Assert.assertFalse((boolean)this.update.shouldBeApplied());
    }

    @Test
    public void testFileDiffer() throws Exception {
        this.update.doUpdate();
        FileOutputStream output = new FileOutputStream(this.sourceFile);
        output.write("hello".getBytes());
        output.close();
        Assert.assertTrue((boolean)this.update.shouldBeApplied());
        this.update.doUpdate();
        Assert.assertEquals((Object)"hello", (Object)FileUtil.getFileContent((File)this.destFile));
    }
}

