/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.BaseWikiPage;
import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.SymbolicPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import java.io.File;
import java.util.List;
import junit.framework.TestCase;
import util.FileUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class BaseWikiPageTest
extends TestCase {
    private WikiPage linkingPage;

    public void setUp() throws Exception {
        BaseWikiPage root = (BaseWikiPage)InMemoryPage.makeRoot((String)"RooT");
        root.addChildPage("LinkedPage");
        this.linkingPage = root.addChildPage("LinkingPage");
        this.linkingPage.addChildPage("ChildPage");
    }

    public void tearDown() throws Exception {
        FileUtil.deleteFileSystemDirectory((String)"testDir");
    }

    public void testGetChildrenUsesSymbolicPages() throws Exception {
        this.createLink("LinkedPage");
        List children = this.linkingPage.getChildren();
        BaseWikiPageTest.assertEquals((int)2, (int)children.size());
        BaseWikiPageTest.assertEquals((String)"ChildPage", (String)((WikiPage)children.get(0)).getName());
        this.checkSymbolicPage(children.get(1));
    }

    public void testGetChildUsesSymbolicPages() throws Exception {
        this.createLink("LinkedPage");
        this.checkSymbolicPage((Object)this.linkingPage.getChildPage("SymLink"));
    }

    public void testCanCreateSymLinksToExternalDirectories() throws Exception {
        FileUtil.createDir((String)"testDir");
        FileUtil.createDir((String)"testDir/ExternalRoot");
        this.createLink("file://testDir/ExternalRoot");
        this.checkExternalLink();
    }

    private void checkExternalLink() throws Exception {
        WikiPage symPage = this.linkingPage.getChildPage("SymLink");
        BaseWikiPageTest.assertNotNull((Object)symPage);
        BaseWikiPageTest.assertEquals(SymbolicPage.class, symPage.getClass());
        WikiPage realPage = ((SymbolicPage)symPage).getRealPage();
        BaseWikiPageTest.assertEquals(FileSystemPage.class, realPage.getClass());
        BaseWikiPageTest.assertEquals((String)"testDir/ExternalRoot", (String)((FileSystemPage)realPage).getFileSystemPath());
        BaseWikiPageTest.assertEquals((String)"ExternalRoot", (String)((FileSystemPage)realPage).getName());
    }

    public void testExternalSymbolicLinkToNewDirectory() throws Exception {
        FileUtil.createDir((String)"testDir");
        this.createLink("file://testDir/ExternalRoot");
        this.checkExternalLink();
        BaseWikiPageTest.assertTrue((boolean)new File("testDir/ExternalRoot").exists());
    }

    private void createLink(String linkedPagePath) throws Exception {
        PageData data = this.linkingPage.getData();
        WikiPageProperties properties = data.getProperties();
        properties.set("SymbolicLinks");
        properties.getProperty("SymbolicLinks").set("SymLink", linkedPagePath);
        this.linkingPage.commit(data);
    }

    private void checkSymbolicPage(Object page) throws Exception {
        BaseWikiPageTest.assertEquals(SymbolicPage.class, page.getClass());
        SymbolicPage symPage = (SymbolicPage)page;
        BaseWikiPageTest.assertEquals((String)"SymLink", (String)symPage.getName());
        BaseWikiPageTest.assertEquals((String)"LinkedPage", (String)symPage.getRealPage().getName());
    }
}

