/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageType;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class PageTypeTest {
    @Test
    public void fromString() {
        Assert.assertEquals((Object)PageType.SUITE, (Object)PageType.fromString((String)"Suite"));
        Assert.assertEquals((Object)PageType.TEST, (Object)PageType.fromString((String)PageType.TEST.toString()));
        Assert.assertEquals((Object)PageType.STATIC, (Object)PageType.fromString((String)"Static"));
        try {
            PageType.fromString((String)"unknown");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void fromSuiteWikiPage() throws Exception {
        WikiPage page = this.createSuitePage();
        Assert.assertEquals((Object)PageType.SUITE, (Object)PageType.fromWikiPage((WikiPage)page));
    }

    private WikiPage createSuitePage() throws Exception {
        WikiPage page = this.createDefaultPage();
        this.setPageTypeAttribute(page, PageType.SUITE);
        return page;
    }

    private void setPageTypeAttribute(WikiPage page, PageType attribute) throws Exception {
        PageData pageData = page.getData();
        pageData.setAttribute(attribute.toString(), "true");
        page.commit(pageData);
    }

    private WikiPage createDefaultPage() throws Exception {
        WikiPage page = InMemoryPage.makeRoot((String)"RooT");
        return page;
    }

    @Test
    public void fromTestWikiPage() throws Exception {
        WikiPage page = this.createTestPage();
        Assert.assertEquals((Object)PageType.TEST, (Object)PageType.fromWikiPage((WikiPage)page));
    }

    private WikiPage createTestPage() throws Exception {
        WikiPage page = this.createDefaultPage();
        this.setPageTypeAttribute(page, PageType.TEST);
        return page;
    }

    @Test
    public void fromNormalWikiPage() throws Exception {
        WikiPage page = this.createDefaultPage();
        Assert.assertEquals((Object)PageType.STATIC, (Object)PageType.fromWikiPage((WikiPage)page));
    }

    private Collection<Object[]> pageTypeFromPageNameData() {
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        PageTypeTest.addTestData(values, (PageType)PageType.SUITE, (String)"SuitePage");
        PageTypeTest.addTestData(values, (PageType)PageType.SUITE, (String)"PageSuite");
        PageTypeTest.addTestData(values, (PageType)PageType.SUITE, (String)"PageExamples");
        PageTypeTest.addTestData(values, (PageType)PageType.TEST, (String)"TestPage");
        PageTypeTest.addTestData(values, (PageType)PageType.TEST, (String)"PageTest");
        PageTypeTest.addTestData(values, (PageType)PageType.TEST, (String)"ExamplePage");
        PageTypeTest.addTestData(values, (PageType)PageType.TEST, (String)"PageExample");
        PageTypeTest.addTestData(values, (PageType)PageType.STATIC, (String)"NormalPage");
        PageTypeTest.addTestData(values, (PageType)PageType.STATIC, (String)"SuiteSetUp");
        PageTypeTest.addTestData(values, (PageType)PageType.STATIC, (String)"SetUp");
        PageTypeTest.addTestData(values, (PageType)PageType.STATIC, (String)"SuiteTearDown");
        PageTypeTest.addTestData(values, (PageType)PageType.STATIC, (String)"TearDown");
        PageTypeTest.addTestData(values, (PageType)PageType.STATIC, (String)"ExamplesNormal");
        return values;
    }

    private static void addTestData(List<Object[]> values, PageType test, String string) {
        values.add(new Object[]{test, string});
    }

    @Test
    public void pageTypeFromPageName() {
        Collection testData = this.pageTypeFromPageNameData();
        for (Object[] testItem : testData) {
            PageType pageType = (PageType)testItem[0];
            String pageName = (String)testItem[1];
            Assert.assertEquals((Object)pageType, (Object)PageType.getPageTypeForPageName((String)pageName));
        }
    }
}

