/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPagePath;
import junit.framework.TestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class PathParserTest
extends TestCase {
    public WikiPagePath path;

    private WikiPagePath makePath(String pathName) {
        WikiPagePath path = PathParser.parse((String)pathName);
        return path;
    }

    public void testSimpleName() throws Exception {
        this.path = this.makePath("ParentPage");
        PathParserTest.assertEquals((String)"ParentPage", (String)this.path.getFirst());
        PathParserTest.assertTrue((boolean)this.path.getRest().isEmpty());
    }

    public void testTwoComponentName() throws Exception {
        this.path = this.makePath("ParentPage.ChildPage");
        PathParserTest.assertEquals((String)"ParentPage", (String)this.path.getFirst());
        PathParserTest.assertEquals((String)"ChildPage", (String)this.path.getRest().getFirst());
        PathParserTest.assertTrue((boolean)this.path.getRest().getRest().isEmpty());
    }

    public void testAbsolutePath() throws Exception {
        this.path = this.makePath(".ParentPage.ChildPage");
        PathParserTest.assertTrue((boolean)this.path.isAbsolute());
        PathParserTest.assertEquals((String)"ParentPage", (String)this.path.getFirst());
        PathParserTest.assertEquals((String)"ChildPage", (String)this.path.getRest().getFirst());
        PathParserTest.assertTrue((boolean)this.path.getRest().getRest().isEmpty());
    }

    public void testRoot() throws Exception {
        this.path = this.makePath("root");
        PathParserTest.assertTrue((boolean)this.path.isAbsolute());
        PathParserTest.assertTrue((boolean)this.path.isEmpty());
    }

    public void testDot() throws Exception {
        this.path = this.makePath(".");
        PathParserTest.assertTrue((boolean)this.path.isAbsolute());
        PathParserTest.assertTrue((boolean)this.path.isEmpty());
    }

    public void testEmptyString() throws Exception {
        this.path = this.makePath("");
        PathParserTest.assertTrue((boolean)this.path.isEmpty());
    }

    public void testInvalidNames() throws Exception {
        PathParserTest.assertNull((Object)this.makePath("bob"));
        PathParserTest.assertNull((Object)this.makePath("bobMartin"));
        PathParserTest.assertNull((Object)this.makePath("_root"));
    }

    public void testSubPagePath() throws Exception {
        this.path = this.makePath(">MySubPagePath.ChildPage");
        PathParserTest.assertTrue((boolean)this.path.isSubPagePath());
        PathParserTest.assertEquals((String)"MySubPagePath", (String)this.path.getFirst());
        PathParserTest.assertEquals((String)"ChildPage", (String)this.path.getRest().getFirst());
        PathParserTest.assertTrue((boolean)this.path.getRest().getRest().isEmpty());
    }

    public void testBackwardSearchPath() throws Exception {
        this.path = this.makePath("<MySubPagePath.ChildPage");
        PathParserTest.assertTrue((boolean)this.path.isBackwardSearchPath());
        PathParserTest.assertEquals((String)"MySubPagePath", (String)this.path.getFirst());
        PathParserTest.assertEquals((String)"ChildPage", (String)this.path.getRest().getFirst());
        PathParserTest.assertTrue((boolean)this.path.getRest().getRest().isEmpty());
    }

    public void testRender() throws Exception {
        PathParserTest.assertEquals((String)"MyPage", (String)PathParser.render((WikiPagePath)this.makePath("MyPage")));
        PathParserTest.assertEquals((String)".MyPage", (String)PathParser.render((WikiPagePath)this.makePath(".MyPage")));
        WikiPagePath p = PathParser.parse((String)".MyPage");
        p.makeAbsolute();
        PathParserTest.assertEquals((String)".MyPage", (String)PathParser.render((WikiPagePath)p));
        PathParserTest.assertEquals((String)".", (String)PathParser.render((WikiPagePath)PathParser.parse((String)".")));
        PathParserTest.assertEquals((String)"<MyPage", (String)PathParser.render((WikiPagePath)this.makePath("<MyPage")));
        PathParserTest.assertEquals((String)">MyPage", (String)PathParser.render((WikiPagePath)this.makePath(">MyPage")));
    }
}

