/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.VersionInfo;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.regex.Matcher;
import junit.framework.TestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class VersionInfoTest
extends TestCase {
    public void testRegex() throws Exception {
        Matcher match = VersionInfo.COMPEX_NAME_PATTERN.matcher("01234567890123");
        VersionInfoTest.assertTrue((boolean)match.find());
        VersionInfoTest.assertEquals((String)"01234567890123", (String)match.group(2));
        match = VersionInfo.COMPEX_NAME_PATTERN.matcher("Joe-01234567890123");
        VersionInfoTest.assertTrue((boolean)match.find());
        VersionInfoTest.assertEquals((String)"Joe", (String)match.group(1));
        VersionInfoTest.assertEquals((String)"01234567890123", (String)match.group(2));
    }

    public void testGetVersionNumber() throws Exception {
        VersionInfoTest.assertEquals((String)"01234567890123", (String)VersionInfo.getVersionNumber((String)"01234567890123"));
        VersionInfoTest.assertEquals((String)"01234567890123", (String)VersionInfo.getVersionNumber((String)"Joe-01234567890123"));
        VersionInfoTest.assertEquals((String)"09876543210987", (String)VersionInfo.getVersionNumber((String)"Joe-09876543210987"));
    }

    public void testSortVersions() throws Exception {
        LinkedList<VersionInfo> list = new LinkedList<VersionInfo>();
        VersionInfo toms = new VersionInfo("Tom-45678901234567");
        VersionInfo anons = new VersionInfo("56789012345678");
        VersionInfo jerrys = new VersionInfo("Jerry-01234567890123");
        VersionInfo joes = new VersionInfo("Joe-43210987654321");
        list.add(toms);
        list.add(anons);
        list.add(jerrys);
        list.add(joes);
        Collections.sort(list);
        VersionInfoTest.assertEquals((Object)jerrys, list.get(0));
        VersionInfoTest.assertEquals((Object)joes, list.get(1));
        VersionInfoTest.assertEquals((Object)toms, list.get(2));
        VersionInfoTest.assertEquals((Object)anons, list.get(3));
    }

    public void testParts() throws Exception {
        VersionInfo version = new VersionInfo("joe-20030101010101");
        VersionInfoTest.assertEquals((String)"joe", (String)version.getAuthor());
        VersionInfoTest.assertEquals((String)"joe-20030101010101", (String)version.getName());
    }

    public void testGetCreationTime() throws Exception {
        VersionInfo version = new VersionInfo("joe-20030101010101");
        Date date = version.getCreationTime();
        VersionInfoTest.assertEquals((String)"20030101010101", (String)VersionInfo.makeVersionTimeFormat().format(date));
    }

    public void testGetAuthor() throws Exception {
        this.checkAuthor("01234567890123", "");
        this.checkAuthor("123-01234567890123", "");
        this.checkAuthor("-123-01234567890123", "");
        this.checkAuthor("user-01234567890123", "user");
        this.checkAuthor("user-123-01234567890123", "user");
        this.checkAuthor("abc123-123-01234567890123", "abc123");
        this.checkAuthor("abc123efg-123-01234567890123", "abc123efg");
        this.checkAuthor("joe <joe@blo.com>-123-01234567890123", "joe <joe@blo.com>");
    }

    private void checkAuthor(String versionName, String author) throws Exception {
        VersionInfo version = new VersionInfo(versionName);
        VersionInfoTest.assertEquals((String)author, (String)version.getAuthor());
    }

    public void testConvertVersionNameToAge() throws Exception {
        Date now = new GregorianCalendar(2003, 0, 1, 0, 0, 1).getTime();
        Date tenSeconds = new GregorianCalendar(2003, 0, 1, 0, 0, 11).getTime();
        Date twoMinutes = new GregorianCalendar(2003, 0, 1, 0, 2, 1).getTime();
        Date fiftyNineSecs = new GregorianCalendar(2003, 0, 1, 0, 1, 0).getTime();
        Date oneHour = new GregorianCalendar(2003, 0, 1, 1, 0, 1).getTime();
        Date fiveDays = new GregorianCalendar(2003, 0, 6, 0, 0, 1).getTime();
        Date years = new GregorianCalendar(2024, 0, 1, 0, 0, 1).getTime();
        VersionInfoTest.assertEquals((String)"10 seconds", (String)VersionInfo.howLongAgoString((Date)now, (Date)tenSeconds));
        VersionInfoTest.assertEquals((String)"2 minutes", (String)VersionInfo.howLongAgoString((Date)now, (Date)twoMinutes));
        VersionInfoTest.assertEquals((String)"59 seconds", (String)VersionInfo.howLongAgoString((Date)now, (Date)fiftyNineSecs));
        VersionInfoTest.assertEquals((String)"1 hour", (String)VersionInfo.howLongAgoString((Date)now, (Date)oneHour));
        VersionInfoTest.assertEquals((String)"5 days", (String)VersionInfo.howLongAgoString((Date)now, (Date)fiveDays));
        VersionInfoTest.assertEquals((String)"21 years", (String)VersionInfo.howLongAgoString((Date)now, (Date)years));
    }
}

