/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import junit.framework.TestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class WikiPagePathTest
extends TestCase {
    public WikiPagePath path;

    protected void setUp() throws Exception {
        this.path = new WikiPagePath();
    }

    public void testEmptyPath() throws Exception {
        WikiPagePathTest.assertTrue((boolean)this.path.isEmpty());
        WikiPagePathTest.assertNull((Object)this.path.getFirst());
        WikiPagePathTest.assertTrue((boolean)this.path.getRest().isEmpty());
    }

    public void testAddOneName() throws Exception {
        this.path.addNameToEnd("bob");
        WikiPagePathTest.assertEquals((String)"bob", (String)this.path.getFirst());
        WikiPagePathTest.assertFalse((boolean)this.path.isEmpty());
        WikiPagePathTest.assertTrue((boolean)this.path.getRest().isEmpty());
    }

    public void testAddTwoNames() throws Exception {
        this.path.addNameToEnd("bob");
        this.path.addNameToEnd("martin");
        WikiPagePathTest.assertFalse((boolean)this.path.isEmpty());
        WikiPagePathTest.assertEquals((String)"bob", (String)this.path.getFirst());
        WikiPagePath rest = this.path.getRest();
        WikiPagePathTest.assertNotNull((Object)rest);
        WikiPagePathTest.assertEquals((String)"martin", (String)rest.getFirst());
        WikiPagePathTest.assertTrue((boolean)rest.getRest().isEmpty());
    }

    public void testRenderEmptyPath() throws Exception {
        String renderedPath = PathParser.render((WikiPagePath)this.path);
        WikiPagePathTest.assertEquals((String)"", (String)renderedPath);
    }

    public void testRenderSimplePath() throws Exception {
        this.path.addNameToEnd("Bob");
        String renderedPath = PathParser.render((WikiPagePath)this.path);
        WikiPagePathTest.assertEquals((String)"Bob", (String)renderedPath);
    }

    public void testRenderComplexPaths() throws Exception {
        this.path.addNameToEnd("Bob");
        this.path.addNameToEnd("Martin");
        String renderedPath = PathParser.render((WikiPagePath)this.path);
        WikiPagePathTest.assertEquals((String)"Bob.Martin", (String)renderedPath);
    }

    public void testPop() throws Exception {
        this.path.addNameToEnd("Micah");
        this.path.removeNameFromEnd();
        WikiPagePathTest.assertEquals((String)"", (String)PathParser.render((WikiPagePath)this.path));
        this.path.addNameToEnd("Micah");
        this.path.addNameToEnd("Martin");
        this.path.removeNameFromEnd();
        WikiPagePathTest.assertEquals((String)"Micah", (String)PathParser.render((WikiPagePath)this.path));
        this.path.removeNameFromEnd();
        WikiPagePathTest.assertEquals((String)"", (String)PathParser.render((WikiPagePath)this.path));
    }

    public void testConstructorWithPage() throws Exception {
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        PageCrawler crawler = root.getPageCrawler();
        WikiPagePath abcdPath = PathParser.parse((String)"AaA.BbB.CcC.DdD");
        WikiPagePath grandchildPath = PathParser.parse((String)"PageOne.ChildOne.GrandChildOne");
        WikiPage page1 = crawler.addPage(root, abcdPath);
        WikiPage page2 = crawler.addPage(root, grandchildPath);
        WikiPagePath page1Path = new WikiPagePath(page1);
        WikiPagePathTest.assertEquals((Object)abcdPath, (Object)page1Path);
        WikiPagePath page2Path = new WikiPagePath(page2);
        WikiPagePathTest.assertEquals((Object)grandchildPath, (Object)page2Path);
    }

    public void testAppend() throws Exception {
        WikiPagePath path = new WikiPagePath();
        WikiPagePath a = PathParser.parse((String)"PageA");
        WikiPagePath pageAPath = path.append(a);
        WikiPagePathTest.assertEquals((String)"PageA", (String)PathParser.render((WikiPagePath)pageAPath));
        WikiPagePath pageBPath = PathParser.parse((String)"PageB");
        WikiPagePath pageABPath = pageAPath.append(pageBPath);
        WikiPagePathTest.assertEquals((String)"PageA.PageB", (String)PathParser.render((WikiPagePath)pageABPath));
    }

    public void testIsAbsolute() throws Exception {
        WikiPagePathTest.assertTrue((boolean)PathParser.parse((String)".AbsolutePage").isAbsolute());
        WikiPagePathTest.assertFalse((boolean)PathParser.parse((String)"RelativePage").isAbsolute());
    }

    public void testGetRelativePath() throws Exception {
        WikiPagePath somePageAbsolutePath = PathParser.parse((String)".SomePage");
        WikiPagePathTest.assertEquals((String)"SomePage", (String)PathParser.render((WikiPagePath)somePageAbsolutePath.relativePath()));
        WikiPagePath somePagePath = PathParser.parse((String)"SomePage");
        WikiPagePathTest.assertEquals((String)"SomePage", (String)PathParser.render((WikiPagePath)somePagePath.relativePath()));
    }

    public void testEquals() throws Exception {
        WikiPagePathTest.assertEquals((Object)PathParser.parse((String)"PageOne"), (Object)PathParser.parse((String)"PageOne"));
        WikiPagePathTest.assertFalse((boolean)PathParser.parse((String)"PageOne").equals((Object)PathParser.parse((String)"PageTwo")));
        WikiPagePathTest.assertFalse((boolean)PathParser.parse((String)"PageOne").equals((Object)"a string"));
        WikiPagePathTest.assertEquals((Object)PathParser.parse((String)"PageOne.PageTwo"), (Object)PathParser.parse((String)"PageOne.PageTwo"));
        WikiPagePathTest.assertFalse((boolean)PathParser.parse((String)"PageOne.PageTwo").equals((Object)PathParser.parse((String)"PageOne.PageThree")));
        WikiPagePathTest.assertFalse((boolean)PathParser.parse((String)"PageOne").equals((Object)PathParser.parse((String)".PageOne")));
    }

    public void testCompareTo() throws Exception {
        WikiPagePath a = PathParser.parse((String)"PageA");
        WikiPagePath ab = PathParser.parse((String)"PageA.PageB");
        WikiPagePath b = PathParser.parse((String)"PageB");
        WikiPagePath aa = PathParser.parse((String)"PageA.PageA");
        WikiPagePath bb = PathParser.parse((String)"PageB.PageB");
        WikiPagePath ba = PathParser.parse((String)"PageB.PageA");
        WikiPagePathTest.assertTrue((a.compareTo((Object)a) == 0 ? 1 : 0) != 0);
        WikiPagePathTest.assertTrue((a.compareTo((Object)b) != 0 ? 1 : 0) != 0);
        WikiPagePathTest.assertTrue((ab.compareTo((Object)ab) == 0 ? 1 : 0) != 0);
        WikiPagePathTest.assertTrue((a.compareTo((Object)b) == -1 ? 1 : 0) != 0);
        WikiPagePathTest.assertTrue((aa.compareTo((Object)ab) == -1 ? 1 : 0) != 0);
        WikiPagePathTest.assertTrue((ba.compareTo((Object)bb) == -1 ? 1 : 0) != 0);
        WikiPagePathTest.assertTrue((b.compareTo((Object)a) == 1 ? 1 : 0) != 0);
        WikiPagePathTest.assertTrue((ab.compareTo((Object)aa) == 1 ? 1 : 0) != 0);
        WikiPagePathTest.assertTrue((bb.compareTo((Object)ba) == 1 ? 1 : 0) != 0);
    }

    public void testMakeAbsolute() throws Exception {
        WikiPagePath p = PathParser.parse((String)"PathOne");
        p.makeAbsolute();
        WikiPagePathTest.assertTrue((boolean)p.isAbsolute());
        WikiPagePath empty = new WikiPagePath();
        empty.makeAbsolute();
        WikiPagePathTest.assertTrue((boolean)empty.isAbsolute());
    }

    public void testAbsoluteModeIsMutuallyExclusive() throws Exception {
        this.path = PathParser.parse((String)"<MyPage");
        WikiPagePathTest.assertTrue((boolean)this.path.isBackwardSearchPath());
        this.path.makeAbsolute();
        WikiPagePathTest.assertFalse((boolean)this.path.isBackwardSearchPath());
    }

    public void testParentPath() throws Exception {
        WikiPagePath path2 = new WikiPagePath();
        WikiPagePathTest.assertEquals((Object)path2, (Object)this.path.parentPath());
        this.path.addNameToEnd("AbC");
        WikiPagePathTest.assertEquals((Object)path2, (Object)this.path.parentPath());
        this.path.addNameToEnd("XyZ");
        path2.addNameToEnd("AbC");
        WikiPagePathTest.assertEquals((Object)path2, (Object)this.path.parentPath());
    }

    public void testEquality() throws Exception {
        WikiPagePath path1 = new WikiPagePath();
        WikiPagePath path2 = new WikiPagePath();
        WikiPagePathTest.assertEquals((Object)path1, (Object)path2);
        WikiPagePathTest.assertEquals((Object)path2, (Object)path1);
        path1.addNameToEnd("AbC");
        WikiPagePathTest.assertFalse((boolean)path1.equals((Object)path2));
        WikiPagePathTest.assertFalse((boolean)path2.equals((Object)path1));
        path2.addNameToEnd("AbC");
        WikiPagePathTest.assertEquals((Object)path1, (Object)path2);
        path1.addNameToEnd("XyZ");
        path2.addNameToEnd("XyZ");
        WikiPagePathTest.assertEquals((Object)path1, (Object)path2);
        path1.removeNameFromEnd();
        WikiPagePathTest.assertFalse((boolean)path1.equals((Object)path2));
        path2.removeNameFromEnd();
        WikiPagePathTest.assertEquals((Object)path1, (Object)path2);
    }

    public void testClone() throws Exception {
        WikiPagePath abs = PathParser.parse((String)".MyPage");
        WikiPagePath rel = PathParser.parse((String)"MyPage");
        WikiPagePath sub = PathParser.parse((String)">MyPage");
        WikiPagePath back = PathParser.parse((String)"<MyPage");
        WikiPagePathTest.assertEquals((Object)abs, (Object)abs.clone());
        WikiPagePathTest.assertEquals((Object)rel, (Object)rel.clone());
        WikiPagePathTest.assertEquals((Object)sub, (Object)sub.clone());
        WikiPagePathTest.assertEquals((Object)back, (Object)back.clone());
    }

    public void testStartsWith() throws Exception {
        WikiPagePath path2 = new WikiPagePath();
        WikiPagePathTest.assertTrue((boolean)path2.startsWith(this.path));
        this.path.addNameToEnd("AbC");
        WikiPagePathTest.assertTrue((boolean)this.path.startsWith(path2));
        path2.addNameToEnd("AbC");
        WikiPagePathTest.assertTrue((boolean)this.path.startsWith(path2));
        this.path.addNameToEnd("DeF");
        WikiPagePathTest.assertTrue((boolean)this.path.startsWith(path2));
        path2.addNameToEnd("XyZ");
        WikiPagePathTest.assertFalse((boolean)this.path.startsWith(path2));
        path2.removeNameFromEnd();
        path2.addNameToEnd("DeF");
        WikiPagePathTest.assertTrue((boolean)this.path.startsWith(path2));
        path2.addNameToEnd("XyZ");
        WikiPagePathTest.assertFalse((boolean)this.path.startsWith(path2));
    }

    public void testWithNameAdded() throws Exception {
        WikiPagePath path2 = new WikiPagePath();
        path2.addNameToEnd("AbC");
        WikiPagePath path3 = this.path.withNameAdded("AbC");
        WikiPagePathTest.assertEquals((Object)path2, (Object)path3);
        WikiPagePathTest.assertNotSame((Object)path3, (Object)path2);
        WikiPagePathTest.assertNotSame((Object)path3, (Object)this.path);
    }

    public void testSubstract() throws Exception {
        WikiPagePath path123 = new WikiPagePath(new String[]{"OnE", "TwO", "ThreE"});
        WikiPagePath path12 = new WikiPagePath(new String[]{"OnE", "TwO"});
        WikiPagePath path1 = new WikiPagePath(new String[]{"OnE"});
        WikiPagePath blah = new WikiPagePath(new String[]{"BlaH"});
        WikiPagePathTest.assertEquals((Object)new WikiPagePath(new String[]{"ThreE"}), (Object)path123.subtractFromFront(path12));
        WikiPagePathTest.assertEquals((Object)new WikiPagePath(new String[]{"TwO", "ThreE"}), (Object)path123.subtractFromFront(path1));
        WikiPagePathTest.assertEquals((Object)new WikiPagePath(new String[]{"TwO"}), (Object)path12.subtractFromFront(path1));
        WikiPagePathTest.assertEquals((Object)path123, (Object)path123.subtractFromFront(blah));
        WikiPagePathTest.assertEquals((Object)new WikiPagePath(), (Object)path123.subtractFromFront(path123));
    }
}

