/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import java.util.List;
import util.Maybe;

public class Help
extends SymbolType
implements Rule,
Translation {
    private static final String editableOption = "-editable";

    public Help() {
        super("Help");
        this.wikiMatcher(new Matcher().string("!help"));
        this.wikiRule((Rule)this);
        this.htmlTranslation((Translation)this);
    }

    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        String option;
        List lookAhead = parser.peek(new SymbolType[]{SymbolType.Whitespace, SymbolType.Text});
        if (lookAhead.size() != 0 && (option = ((Symbol)lookAhead.get(1)).getContent()).equals(editableOption)) {
            current.putProperty(editableOption, "");
            parser.moveNext(2);
        }
        return new Maybe((Object)current);
    }

    public String toTarget(Translator translator, Symbol symbol) {
        String editText;
        String helpText = translator.getPage().getProperty("Help");
        String string = editText = helpText.length() > 0 ? "edit" : "edit help text";
        if (symbol.hasProperty(editableOption)) {
            helpText = helpText + " <a href=\"" + translator.getPage().getFullPath() + "?properties\">(" + editText + ")</a>";
        }
        return helpText;
    }
}

