/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.ScanString;
import fitnesse.wikitext.parser.SymbolStream;
import fitnesse.wikitext.parser.SymbolType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import util.Maybe;

public class Matcher {
    private static final List<Character> defaultList = Collections.unmodifiableList(Arrays.asList(Character.valueOf('\u0000')));
    private List<ScanMatch> matches = new ArrayList(4);
    private List<Character> firsts = null;

    public List<Character> getFirsts() {
        return this.firsts != null ? this.firsts : defaultList;
    }

    public Matcher whitespace() {
        if (this.firsts == null) {
            this.firsts = defaultList;
        }
        this.matches.add(new /* Unavailable Anonymous Inner Class!! */);
        return this;
    }

    public Matcher startLine() {
        this.matches.add(new /* Unavailable Anonymous Inner Class!! */);
        return this;
    }

    public Matcher startLineOrCell() {
        this.matches.add(new /* Unavailable Anonymous Inner Class!! */);
        return this;
    }

    private boolean isStartLine(ScanString input, SymbolStream symbols, int offset) {
        return input.startsLine(offset) || symbols.get(0).isStartLine();
    }

    private boolean isStartCell(SymbolStream symbols) {
        return symbols.get(0).isStartCell() || symbols.get(0).isType(SymbolType.Whitespace) && (symbols.get(1).isStartCell() || symbols.get(1).isLineType());
    }

    public Matcher string(String delimiter) {
        if (this.firsts == null) {
            this.firsts = Collections.singletonList(Character.valueOf(delimiter.charAt(0)));
        }
        this.matches.add(new /* Unavailable Anonymous Inner Class!! */);
        return this;
    }

    public Matcher listDigit() {
        this.firstIsDigit('1');
        this.matches.add(new /* Unavailable Anonymous Inner Class!! */);
        return this;
    }

    private boolean isDigitInput(char firstDigit, ScanString input, int offset) {
        for (char i = firstDigit; i <= '9'; i = (char)(i + '\u0001')) {
            if (!input.matches(new String(new char[]{i}), offset)) continue;
            return true;
        }
        return false;
    }

    private void firstIsDigit(char startDigit) {
        if (this.firsts == null) {
            this.firsts = new ArrayList();
            for (char i = startDigit; i <= '9'; i = (char)(i + '\u0001')) {
                this.firsts.add(Character.valueOf(i));
            }
        }
    }

    public Matcher digits() {
        this.firstIsDigit('0');
        this.matches.add(new /* Unavailable Anonymous Inner Class!! */);
        return this;
    }

    public Matcher ignoreWhitespace() {
        this.matches.add(new /* Unavailable Anonymous Inner Class!! */);
        return this;
    }

    public Matcher repeat(char delimiter) {
        if (this.firsts == null) {
            this.firsts = Collections.singletonList(Character.valueOf(delimiter));
        }
        this.matches.add(new /* Unavailable Anonymous Inner Class!! */);
        return this;
    }

    public Matcher endsWith(char[] terminators) {
        this.matches.add(new /* Unavailable Anonymous Inner Class!! */);
        return this;
    }

    public Maybe<Integer> makeMatch(ScanString input, SymbolStream symbols) {
        int totalLength = 0;
        for (ScanMatch match : this.matches) {
            Maybe matchLength = match.match(input, symbols, totalLength);
            if (matchLength.isNothing()) {
                return Maybe.noInteger;
            }
            totalLength += ((Integer)matchLength.getValue()).intValue();
        }
        return new Maybe((Object)totalLength);
    }

    static /* synthetic */ boolean access$000(Matcher x0, ScanString x1, SymbolStream x2, int x3) {
        return x0.isStartLine(x1, x2, x3);
    }

    static /* synthetic */ boolean access$100(Matcher x0, SymbolStream x1) {
        return x0.isStartCell(x1);
    }

    static /* synthetic */ boolean access$200(Matcher x0, char x1, ScanString x2, int x3) {
        return x0.isDigitInput(x1, x2, x3);
    }
}

