/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Matchable;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.ScanString;
import fitnesse.wikitext.parser.Scanner;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolMatch;
import fitnesse.wikitext.parser.SymbolMatcher;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolStream;
import fitnesse.wikitext.parser.SymbolType;
import java.util.ArrayList;
import java.util.Arrays;
import util.Maybe;

public class ParseSpecification {
    public static final int nestingPriority = 2;
    public static final int tablePriority = 1;
    public static final int normalPriority = 0;
    private SymbolProvider provider = SymbolProvider.wikiParsingProvider;
    private ArrayList<SymbolType> terminators = new ArrayList();
    private ArrayList<SymbolType> ignoresFirst = new ArrayList();
    private ArrayList<SymbolType> ends = new ArrayList();
    private int priority = 0;

    public ParseSpecification provider(SymbolProvider provider) {
        this.provider = provider;
        return this;
    }

    public ParseSpecification provider(ParseSpecification specification) {
        this.provider = specification.provider;
        return this;
    }

    public ParseSpecification priority(int priority) {
        this.priority = priority;
        return this;
    }

    public ParseSpecification terminator(SymbolType terminator) {
        this.terminators.add(terminator);
        return this;
    }

    public ParseSpecification ignoreFirst(SymbolType ignoreFirst) {
        this.ignoresFirst.add(ignoreFirst);
        return this;
    }

    public void clearIgnoresFirst() {
        this.ignoresFirst.clear();
    }

    public ParseSpecification end(SymbolType end) {
        this.ends.add(end);
        return this;
    }

    public ParseSpecification makeSpecification(SymbolProvider providerModel, SymbolType[] providerTypes) {
        SymbolProvider newProvider = new SymbolProvider(providerModel);
        newProvider.addTypes((Iterable)this.ends);
        newProvider.addTypes((Iterable)this.terminators);
        newProvider.addTypes(Arrays.asList(providerTypes));
        return new ParseSpecification().provider(newProvider);
    }

    public boolean endsOn(SymbolType symbolType) {
        return this.contains((Iterable)this.ends, (Matchable)symbolType);
    }

    public SymbolMatch findMatch(ScanString input, int startPosition, SymbolStream symbols) {
        return this.provider.findMatch(Character.valueOf(input.charAt(0)), (SymbolMatcher)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean matchesFor(SymbolType symbolType) {
        return this.provider.matchesFor(symbolType);
    }

    public boolean owns(SymbolType current, ParseSpecification other) {
        return this.terminatesOn(current) && this.priority > other.priority;
    }

    public Symbol parse(Parser parser, Scanner scanner) {
        Symbol result = scanner.getOffset() == 0 ? new Symbol(SymbolType.SymbolList, 100) : new Symbol(SymbolType.SymbolList);
        while (true) {
            Scanner backup = new Scanner(scanner);
            scanner.moveNextIgnoreFirst(this);
            if (scanner.isEnd()) break;
            Symbol currentToken = scanner.getCurrent();
            if (this.endsOn(currentToken.getType()) || parser.parentOwns(currentToken.getType(), this)) {
                scanner.copy(backup);
                break;
            }
            if (this.terminatesOn(currentToken.getType())) break;
            Rule currentRule = currentToken.getType().getWikiRule();
            Maybe parsedSymbol = currentRule.parse(currentToken, parser);
            if (parsedSymbol.isNothing()) {
                this.ignoreFirst(currentToken.getType());
                scanner.copy(backup);
                continue;
            }
            result.add((Symbol)parsedSymbol.getValue());
            this.clearIgnoresFirst();
        }
        return result;
    }

    private boolean terminatesOn(SymbolType symbolType) {
        return this.contains((Iterable)this.terminators, (Matchable)symbolType);
    }

    private boolean contains(Iterable<SymbolType> terminators, Matchable currentType) {
        for (SymbolType terminator : terminators) {
            if (!currentType.matchesFor(terminator)) continue;
            return true;
        }
        return false;
    }

    private boolean ignores(Matchable symbolType) {
        return this.contains((Iterable)this.ignoresFirst, symbolType);
    }

    static /* synthetic */ boolean access$000(ParseSpecification x0, Matchable x1) {
        return x0.ignores(x1);
    }
}

