/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.List;
import util.Maybe;
import util.SystemTimeKeeper;

public class Today
extends SymbolType
implements Rule,
Translation {
    private static final String Format = "Format";
    private static final String Increment = "Increment";

    public Today() {
        super("Today");
        this.wikiMatcher(new Matcher().string("!today"));
        this.wikiRule((Rule)this);
        this.htmlTranslation((Translation)this);
    }

    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        List lookAhead = parser.peek(new SymbolType[]{SymbolType.Whitespace, SymbolType.Text});
        if (lookAhead.size() != 0) {
            String option = ((Symbol)lookAhead.get(1)).getContent();
            if (this.isDateFormatOption(option)) {
                current.putProperty(Format, option);
                parser.moveNext(2);
            }
        } else {
            lookAhead = parser.peek(new SymbolType[]{SymbolType.Whitespace, SymbolType.OpenParenthesis});
            if (lookAhead.size() != 0) {
                parser.moveNext(2);
                Maybe format = parser.parseToAsString(SymbolType.CloseParenthesis);
                if (format.isNothing()) {
                    return Symbol.nothing;
                }
                current.putProperty(Format, (String)format.getValue());
            }
        }
        lookAhead = parser.peek(new SymbolType[]{SymbolType.Whitespace, SymbolType.Delta});
        if (lookAhead.size() != 0) {
            String increment = ((Symbol)lookAhead.get(1)).getContent();
            current.putProperty(Increment, increment);
            parser.moveNext(2);
        }
        return new Maybe((Object)current);
    }

    private boolean isDateFormatOption(String option) {
        return option.equals("-t") || option.equals("-xml");
    }

    public String toTarget(Translator translator, Symbol symbol) {
        String increment = symbol.getProperty(Increment);
        int incrementDays = increment.startsWith("+") ? Integer.parseInt(increment.substring(1)) : (increment.startsWith("-") ? -Integer.parseInt(increment.substring(1)) : 0);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(SystemTimeKeeper.now());
        calendar.add(5, incrementDays);
        return new SimpleDateFormat(this.makeFormat(symbol.getProperty(Format))).format(calendar.getTime());
    }

    private String makeFormat(String format) {
        return format.equals("-t") ? "dd MMM, yyyy HH:mm" : (format.equals("-xml") ? "yyyy-MM-dd'T'HH:mm:ss" : (format.length() == 0 ? "dd MMM, yyyy" : format));
    }
}

