/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.VariableSource;
import util.Maybe;

public class VariableFinder
implements VariableSource {
    private ParsingPage page;

    public VariableFinder(ParsingPage page) {
        this.page = page;
    }

    public Maybe<String> findVariable(String name) {
        Maybe result = this.page.getSpecialVariableValue(name);
        if (!result.isNothing()) {
            return result;
        }
        result = this.findVariableInPages(name);
        if (!result.isNothing()) {
            return result;
        }
        String value = System.getenv(name);
        if (value != null) {
            return new Maybe((Object)value);
        }
        value = System.getProperty(name);
        if (value != null) {
            return new Maybe((Object)value);
        }
        return Maybe.noString;
    }

    private Maybe<String> findVariableInPages(String name) {
        Maybe localVariable = this.page.findVariable(name);
        if (!localVariable.isNothing()) {
            return new Maybe(localVariable.getValue());
        }
        return this.lookInParentPages(name);
    }

    private Maybe<String> lookInParentPages(String name) {
        for (SourcePage sourcePage : this.page.getPage().getAncestors()) {
            Maybe result;
            if (!this.page.inCache(sourcePage)) {
                Parser.make((ParsingPage)this.page.copyForPage(sourcePage), (String)sourcePage.getContent()).parse();
                this.page.putVariable(sourcePage, "", Maybe.noString);
            }
            if ((result = this.page.findVariable(sourcePage, name)).isNothing()) continue;
            return result;
        }
        return Maybe.noString;
    }
}

