/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.html.HtmlElement;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.WikiSourcePage;
import fitnesse.wikitext.test.ParserTestHelper;
import fitnesse.wikitext.test.TestRoot;
import org.junit.Assert;
import org.junit.Test;

public class DefineTest {
    @Test
    public void scansDefine() {
        ParserTestHelper.assertScansTokenType((String)"!define x {y}", (String)"Define", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"|!define x {y}|/n", (String)"Define", (boolean)true);
    }

    @Test
    public void translatesDefines() {
        this.assertTranslatesDefine("!define x {y}", "x=y");
        this.assertTranslatesDefine("!define BoBo {y}", "BoBo=y");
        this.assertTranslatesDefine("!define BoBo  {y}", "BoBo=y");
        this.assertTranslatesDefine("!define x {}", "x=");
        this.assertTranslatesDefine("!define x_x {y}", "x_x=y");
        this.assertTranslatesDefine("!define x.x {y}", "x.x=y");
        this.assertTranslatesDefine("!define x (y)", "x=y");
        this.assertTranslatesDefine("!define x [y]", "x=y");
        this.assertTranslatesDefine("!define x {''y''}", "x=''y''");
        ParserTestHelper.assertTranslatesTo((String)"|!define x {y}", (String)"|!define x {y}");
    }

    @Test
    public void definesValues() {
        this.assertDefinesValue("!define x {y}", "x", "y");
        this.assertDefinesValue("|!define x {y}|\n", "x", "y");
    }

    @Test
    public void definesTable() {
        this.assertTranslatesDefine("!define x {|a|b|c|}", "x=|a|b|c|");
    }

    @Test
    public void definesTwoTables() {
        WikiPage pageOne = new TestRoot().makePage("PageOne");
        ParserTestHelper.assertTranslatesTo((WikiPage)pageOne, (String)"!define x {|a|b|c|}\n!define y {|d|e|f|}", (String)(this.MakeDefinition("x=|a|b|c|") + HtmlElement.endl + "<br/>" + this.MakeDefinition("y=|d|e|f|") + HtmlElement.endl));
    }

    @Test
    public void CopiesSymbolValueWhenParsed() {
        this.assertDefinesValue("!define y {yvalue}\n!define x y\n", "x", "yvalue");
    }

    private void assertDefinesValue(String input, String name, String definedValue) {
        WikiPage pageOne = new TestRoot().makePage("PageOne", input);
        ParsingPage page = new ParsingPage((SourcePage)new WikiSourcePage(pageOne));
        Parser.make((ParsingPage)page, (String)input).parse();
        Assert.assertEquals((Object)definedValue, (Object)page.findVariable(name).getValue());
    }

    private void assertTranslatesDefine(String input, String definition) {
        WikiPage pageOne = new TestRoot().makePage("PageOne");
        ParserTestHelper.assertTranslatesTo((WikiPage)pageOne, (String)input, (String)(this.MakeDefinition(definition) + HtmlElement.endl));
    }

    private String MakeDefinition(String definition) {
        return "<span class=\"meta\">variable defined: " + definition + "</span>";
    }
}

