/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.wikitext.test.ParserTestHelper;
import org.junit.Assert;
import org.junit.Test;

public class EqualPairTest {
    @Test
    public void scansTripleQuotes() {
        ParserTestHelper.assertScansTokenType((String)"'''bold'''", (String)"Bold", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"''''bold''''", (String)"Bold", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"'' 'not bold' ''", (String)"Bold", (boolean)false);
        ParserTestHelper.assertScansTokenType((String)"''''some text' '''", (String)"Bold", (boolean)true);
    }

    @Test
    public void translatesBold() {
        ParserTestHelper.assertTranslatesTo((String)"'''bold text'''", (String)"<b>bold text</b>");
    }

    @Test
    public void scansDoubleQuotes() {
        ParserTestHelper.assertScansTokenType((String)"''italic''", (String)"Italic", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"'' 'italic' ''", (String)"Italic", (boolean)true);
    }

    @Test
    public void translatesItalic() {
        ParserTestHelper.assertTranslatesTo((String)"''italic text''", (String)"<i>italic text</i>");
    }

    @Test
    public void translatesBoldItalic() {
        ParserTestHelper.assertTranslatesTo((String)"'''''stuff&nonsense'''''", (String)"<b><i>stuff&amp;nonsense</i></b>");
    }

    @Test
    public void ignoresAdjacentItalics() {
        ParserTestHelper.assertTranslatesTo((String)"''", (String)"''");
        ParserTestHelper.assertTranslatesTo((String)"''''", (String)"''''");
    }

    @Test
    public void translatesItalicQuote() {
        ParserTestHelper.assertTranslatesTo((String)"'''''", (String)"<i>'</i>");
    }

    @Test
    public void scansDoubleDashes() {
        ParserTestHelper.assertScansTokenType((String)"abc--123--def", (String)"Strike", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"--- -", (String)"Strike", (boolean)true);
    }

    @Test
    public void translatesStrike() {
        ParserTestHelper.assertTranslatesTo((String)"--some text--", (String)"<strike>some text</strike>");
        ParserTestHelper.assertTranslatesTo((String)"--embedded-dash--", (String)"<strike>embedded-dash</strike>");
    }

    @Test
    public void testEvilExponentialMatch() throws Exception {
        long startTime = System.currentTimeMillis();
        ParserTestHelper.assertTranslatesTo((String)"--1234567890123456789012", (String)"--1234567890123456789012");
        long endTime = System.currentTimeMillis();
        Assert.assertTrue((String)"took too long", (endTime - startTime < 20L ? 1 : 0) != 0);
    }
}

